/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.List;
import javax.jms.Queue;
import org.hornetq.api.jms.HornetQJMSClient;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.extension.messaging.activemq.BinderServiceUtil;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueDefinition;
import org.wildfly.extension.messaging.activemq.jms.JMSQueueService;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;

public class JMSQueueAdd
extends AbstractAddStepHandler {
    public static final JMSQueueAdd INSTANCE = new JMSQueueAdd();

    private JMSQueueAdd() {
        super(JMSQueueDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(context.getCurrentAddress());
        ModelNode selectorNode = CommonAttributes.SELECTOR.resolveModelAttribute(context, model);
        boolean durable = CommonAttributes.DURABLE.resolveModelAttribute(context, model).asBoolean();
        String selector = selectorNode.isDefined() ? selectorNode.asString() : null;
        Service<Queue> queueService = JMSQueueService.installService(name, serviceTarget, serviceName, selector, durable, new String[0]);
        ServiceName jmsQueueServiceName = JMSServices.getJmsQueueBaseServiceName(serviceName).append(new String[]{name});
        for (String entry : CommonAttributes.DESTINATION_ENTRIES.unwrap((ExpressionResolver)context, model)) {
            BinderServiceUtil.installBinderService(serviceTarget, entry, queueService, jmsQueueServiceName);
        }
        List legacyEntries = CommonAttributes.LEGACY_ENTRIES.unwrap((ExpressionResolver)context, model);
        if (!legacyEntries.isEmpty()) {
            Queue legacyQueue = HornetQJMSClient.createQueue((String)name);
            for (String legacyEntry : legacyEntries) {
                BinderServiceUtil.installBinderService(serviceTarget, legacyEntry, legacyQueue);
            }
        }
    }
}

