/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import java.util.Iterator;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;

public interface PathAddressTransformer {
    public static final PathAddressTransformer DEFAULT = new PathAddressTransformer(){

        @Override
        public PathAddress transform(PathElement current, Builder builder) {
            return builder.next(current);
        }
    };

    public PathAddress transform(PathElement var1, Builder var2);

    public static class BuilderImpl
    implements Builder {
        private final Iterator<PathAddressTransformer> transformers;
        private final PathAddress original;
        private PathAddress current = PathAddress.EMPTY_ADDRESS;
        private int idx = 0;

        protected BuilderImpl(Iterator<PathAddressTransformer> transformers, PathAddress original) {
            this.transformers = transformers;
            this.original = original;
        }

        @Override
        public PathAddress getOriginal() {
            return this.original;
        }

        @Override
        public PathAddress getCurrent() {
            return this.current;
        }

        @Override
        public PathAddress getRemaining() {
            return this.original.subAddress(this.idx);
        }

        @Override
        public PathAddress next(PathElement ... elements) {
            this.current = this.current.append(elements);
            int remaining = this.original.size() - this.idx;
            if (remaining == 0) {
                return this.current;
            }
            if (this.transformers.hasNext()) {
                PathAddressTransformer transformer = this.transformers.next();
                PathElement next = this.original.getElement(this.idx++);
                return transformer.transform(next, this);
            }
            throw new IllegalStateException();
        }

        protected PathAddress start() {
            if (this.original == PathAddress.EMPTY_ADDRESS || this.original.size() == 0) {
                return PathAddress.EMPTY_ADDRESS;
            }
            if (this.transformers.hasNext()) {
                PathAddressTransformer transformer = this.transformers.next();
                PathElement next = this.original.getElement(this.idx++);
                return transformer.transform(next, this);
            }
            return this.original;
        }
    }

    public static interface Builder {
        public PathAddress getOriginal();

        public PathAddress getCurrent();

        public PathAddress getRemaining();

        public PathAddress next(PathElement ... var1);
    }

    public static class ReplaceElementKey
    implements PathAddressTransformer {
        private final String newKey;

        public ReplaceElementKey(String newKey) {
            this.newKey = newKey;
        }

        @Override
        public PathAddress transform(PathElement current, Builder builder) {
            PathElement newElement = PathElement.pathElement(this.newKey, current.getValue());
            return builder.next(newElement);
        }
    }

    public static class BasicPathAddressTransformer
    implements PathAddressTransformer {
        private final PathElement swap;

        public BasicPathAddressTransformer(PathElement swap) {
            this.swap = swap;
        }

        @Override
        public PathAddress transform(PathElement current, Builder builder) {
            return builder.next(this.swap);
        }
    }
}

