/*
 * Decompiled with CFR 0.152.
 */
package com.shaded.fasterxml.jackson.databind.cfg;

import com.shaded.fasterxml.jackson.core.Base64Variant;
import com.shaded.fasterxml.jackson.core.SerializableString;
import com.shaded.fasterxml.jackson.core.io.SerializedString;
import com.shaded.fasterxml.jackson.core.type.TypeReference;
import com.shaded.fasterxml.jackson.databind.AnnotationIntrospector;
import com.shaded.fasterxml.jackson.databind.BeanDescription;
import com.shaded.fasterxml.jackson.databind.JavaType;
import com.shaded.fasterxml.jackson.databind.MapperFeature;
import com.shaded.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.shaded.fasterxml.jackson.databind.cfg.BaseSettings;
import com.shaded.fasterxml.jackson.databind.cfg.ConfigFeature;
import com.shaded.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.shaded.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.shaded.fasterxml.jackson.databind.introspect.Annotated;
import com.shaded.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.shaded.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.shaded.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.shaded.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.shaded.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.shaded.fasterxml.jackson.databind.type.TypeBindings;
import com.shaded.fasterxml.jackson.databind.type.TypeFactory;
import com.shaded.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;

public abstract class MapperConfig<T extends MapperConfig<T>>
implements ClassIntrospector.MixInResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final int _mapperFeatures;
    protected final BaseSettings _base;

    protected MapperConfig(BaseSettings base, int mapperFeatures) {
        this._base = base;
        this._mapperFeatures = mapperFeatures;
    }

    protected MapperConfig(MapperConfig<T> src) {
        this._base = src._base;
        this._mapperFeatures = src._mapperFeatures;
    }

    public static <F extends Enum<F>> int collectFeatureDefaults(Class<F> enumClass) {
        int flags = 0;
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            if (!((ConfigFeature)((Object)value)).enabledByDefault()) continue;
            flags |= ((ConfigFeature)((Object)value)).getMask();
        }
        return flags;
    }

    public abstract T with(MapperFeature ... var1);

    public abstract T without(MapperFeature ... var1);

    public abstract T with(MapperFeature var1, boolean var2);

    public final boolean isEnabled(MapperFeature f) {
        return (this._mapperFeatures & f.getMask()) != 0;
    }

    public final boolean hasMapperFeatures(int featureMask) {
        return (this._mapperFeatures & featureMask) == featureMask;
    }

    public final boolean isAnnotationProcessingEnabled() {
        return this.isEnabled(MapperFeature.USE_ANNOTATIONS);
    }

    public final boolean canOverrideAccessModifiers() {
        return this.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS);
    }

    public final boolean shouldSortPropertiesAlphabetically() {
        return this.isEnabled(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY);
    }

    public abstract boolean useRootWrapping();

    public SerializableString compileString(String src) {
        return new SerializedString(src);
    }

    public ClassIntrospector getClassIntrospector() {
        return this._base.getClassIntrospector();
    }

    public AnnotationIntrospector getAnnotationIntrospector() {
        return this._base.getAnnotationIntrospector();
    }

    public VisibilityChecker<?> getDefaultVisibilityChecker() {
        return this._base.getVisibilityChecker();
    }

    public final PropertyNamingStrategy getPropertyNamingStrategy() {
        return this._base.getPropertyNamingStrategy();
    }

    public final HandlerInstantiator getHandlerInstantiator() {
        return this._base.getHandlerInstantiator();
    }

    public final TypeResolverBuilder<?> getDefaultTyper(JavaType baseType) {
        return this._base.getTypeResolverBuilder();
    }

    public abstract SubtypeResolver getSubtypeResolver();

    public final TypeFactory getTypeFactory() {
        return this._base.getTypeFactory();
    }

    public final JavaType constructType(Class<?> cls) {
        return this.getTypeFactory().constructType(cls, (TypeBindings)null);
    }

    public final JavaType constructType(TypeReference<?> valueTypeRef) {
        return this.getTypeFactory().constructType(valueTypeRef.getType(), (TypeBindings)null);
    }

    public JavaType constructSpecializedType(JavaType baseType, Class<?> subclass) {
        return this.getTypeFactory().constructSpecializedType(baseType, subclass);
    }

    public BeanDescription introspectClassAnnotations(Class<?> cls) {
        return this.introspectClassAnnotations(this.constructType(cls));
    }

    public abstract BeanDescription introspectClassAnnotations(JavaType var1);

    public BeanDescription introspectDirectClassAnnotations(Class<?> cls) {
        return this.introspectDirectClassAnnotations(this.constructType(cls));
    }

    public abstract BeanDescription introspectDirectClassAnnotations(JavaType var1);

    public final DateFormat getDateFormat() {
        return this._base.getDateFormat();
    }

    public final Locale getLocale() {
        return this._base.getLocale();
    }

    public final TimeZone getTimeZone() {
        return this._base.getTimeZone();
    }

    public abstract Class<?> getActiveView();

    public Base64Variant getBase64Variant() {
        return this._base.getBase64Variant();
    }

    public abstract ContextAttributes getAttributes();

    public TypeResolverBuilder<?> typeResolverBuilderInstance(Annotated annotated, Class<? extends TypeResolverBuilder<?>> builderClass) {
        TypeResolverBuilder<?> builder;
        HandlerInstantiator hi = this.getHandlerInstantiator();
        if (hi != null && (builder = hi.typeResolverBuilderInstance(this, annotated, builderClass)) != null) {
            return builder;
        }
        return ClassUtil.createInstance(builderClass, this.canOverrideAccessModifiers());
    }

    public TypeIdResolver typeIdResolverInstance(Annotated annotated, Class<? extends TypeIdResolver> resolverClass) {
        TypeIdResolver builder;
        HandlerInstantiator hi = this.getHandlerInstantiator();
        if (hi != null && (builder = hi.typeIdResolverInstance(this, annotated, resolverClass)) != null) {
            return builder;
        }
        return ClassUtil.createInstance(resolverClass, this.canOverrideAccessModifiers());
    }
}

