/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.hawkular.agent.javaagent.InventoryReport;
import org.hawkular.agent.javaagent.JavaAgentMXBean;
import org.hawkular.agent.javaagent.cmd.UpdateCollectionIntervalsCommand;
import org.hawkular.agent.javaagent.config.ConfigConverter;
import org.hawkular.agent.javaagent.config.ConfigManager;
import org.hawkular.agent.javaagent.config.Configuration;
import org.hawkular.agent.javaagent.config.SecurityRealm;
import org.hawkular.agent.javaagent.log.JavaAgentLoggers;
import org.hawkular.agent.javaagent.log.MsgLogger;
import org.hawkular.agent.monitor.cmd.Command;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.protocol.dmr.ModelControllerClientFactory;
import org.hawkular.agent.monitor.service.AgentCoreEngine;
import org.hawkular.agent.monitor.service.ServiceStatus;
import org.hawkular.bus.common.BasicMessage;

public class JavaAgentEngine
extends AgentCoreEngine
implements JavaAgentMXBean {
    private static final MsgLogger log = JavaAgentLoggers.getLogger(JavaAgentEngine.class);
    private static final String MBEAN_OBJECT_NAME = "org.hawkular:type=hawkular-javaagent";
    private final ConfigManager configurationManager;
    private final Map<String, TrustManager[]> trustOnlyTrustManagers = new HashMap<String, TrustManager[]>();
    private final Map<String, SSLContext> trustOnlySslContexts = new HashMap<String, SSLContext>();

    public JavaAgentEngine(File configFile) throws Exception {
        this(new ConfigManager(configFile));
    }

    private JavaAgentEngine(ConfigManager configMgr) throws Exception {
        super(new ConfigConverter(configMgr.getConfiguration(true)).convert());
        log.infoLoadedConfigurationFile(configMgr.getConfigFile().getAbsolutePath());
        this.configurationManager = configMgr;
        JavaAgentEngine.loadSecurityRealms(configMgr.getConfiguration(), this.trustOnlyTrustManagers, this.trustOnlySslContexts);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        mbs.registerMBean(this, new ObjectName(MBEAN_OBJECT_NAME));
    }

    private static void loadSecurityRealms(Configuration config, Map<String, TrustManager[]> trustOnlyTrustManagers, Map<String, SSLContext> trustOnlySslContexts) {
        SecurityRealm[] securityRealms = config.getSecurityRealms();
        if (securityRealms == null) {
            return;
        }
        for (SecurityRealm securityRealm : securityRealms) {
            try {
                String keyStoreType = securityRealm.getKeystoreType();
                String trustManagerAlgorithm = securityRealm.getTrustManagerAlgorithm();
                String keyManagerAlgorithm = securityRealm.getKeyManagerAlgorithm();
                String sslProtocol = securityRealm.getSslProtocol();
                String keyPassword = securityRealm.getKeyPassword() != null ? securityRealm.getKeyPassword() : securityRealm.getKeystorePassword();
                KeyStore keystore = KeyStore.getInstance(keyStoreType);
                try (FileInputStream is = new FileInputStream(securityRealm.getKeystorePath());){
                    keystore.load(is, securityRealm.getKeystorePassword().toCharArray());
                }
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerAlgorithm);
                kmf.init(keystore, keyPassword.toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManagerAlgorithm);
                tmf.init(keystore);
                trustOnlyTrustManagers.put(securityRealm.getName(), tmf.getTrustManagers());
                SSLContext sc = SSLContext.getInstance(sslProtocol);
                sc.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
                trustOnlySslContexts.put(securityRealm.getName(), sc);
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                log.errorBuildingSecurityRealm(securityRealm.getName(), e);
            }
        }
    }

    public void startHawkularAgent(Configuration newConfig) {
        if (newConfig == null) {
            super.startHawkularAgent();
        } else {
            AgentCoreEngineConfiguration agentConfig;
            Configuration oldConfig = this.getConfigurationManager().getConfiguration();
            boolean doNotChangeConfig = oldConfig != null && oldConfig.getSubsystem().getImmutable() != false;
            try {
                agentConfig = new ConfigConverter(doNotChangeConfig ? oldConfig : newConfig).convert();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot start agent - config is invalid", e);
            }
            try {
                if (!doNotChangeConfig) {
                    this.configurationManager.updateConfiguration(newConfig, true);
                }
                super.startHawkularAgent(agentConfig);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ConfigManager getConfigurationManager() {
        return this.configurationManager;
    }

    @Override
    protected Map<String, SSLContext> buildTrustOnlySSLContextValues(AgentCoreEngineConfiguration config) {
        return this.trustOnlySslContexts;
    }

    @Override
    protected Map<String, TrustManager[]> buildTrustOnlyTrustManagersValues(AgentCoreEngineConfiguration config) {
        return this.trustOnlyTrustManagers;
    }

    @Override
    protected ModelControllerClientFactory buildLocalModelControllerClientFactory() {
        return null;
    }

    @Override
    protected AgentCoreEngineConfiguration loadRuntimeConfiguration(AgentCoreEngineConfiguration config) {
        return config;
    }

    @Override
    protected void cleanupDuringStop() {
    }

    @Override
    protected String autoGenerateFeedId() throws Exception {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    @Override
    protected Map<String, Class<? extends Command<? extends BasicMessage, ? extends BasicMessage>>> buildAdditionalCommands() {
        return Collections.singletonMap(UpdateCollectionIntervalsCommand.REQUEST_CLASS.getName(), UpdateCollectionIntervalsCommand.class);
    }

    @Override
    public boolean getImmutable() {
        return this.getConfiguration().getGlobalConfiguration().isImmutable();
    }

    @Override
    public boolean getInContainer() {
        return this.getConfiguration().getGlobalConfiguration().isInContainer();
    }

    @Override
    public void start() {
        Configuration reloadedConfig;
        try {
            reloadedConfig = this.configurationManager.getConfiguration(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot start the agent", e);
        }
        this.startHawkularAgent(reloadedConfig);
    }

    @Override
    public void stop() {
        this.stopHawkularAgent();
    }

    @Override
    public String status() {
        return this.getStatus().name();
    }

    @Override
    public String fullDiscoveryScan() {
        try {
            ServiceStatus status = this.getStatus();
            if (status == ServiceStatus.RUNNING) {
                long start = System.currentTimeMillis();
                this.getProtocolServices().discoverAll();
                long duration = System.currentTimeMillis() - start;
                return String.format("Full inventory discovery scan completed in [%d] milliseconds", duration);
            }
            return String.format("Cannot run discovery scan because the agent is not running. Status is [%s]", new Object[]{status});
        }
        catch (Exception e) {
            return String.format("Error occurred while attempting discovery scan. err=%s", e);
        }
    }

    @Override
    public String inventoryReport() {
        try {
            return InventoryReport.getInventoryReport(this);
        }
        catch (Exception e) {
            return "Cannot obtain inventory report: " + e;
        }
    }
}

