/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.shaded.fasterxml.jackson.annotation.JsonAutoDetect;
import com.shaded.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.agent.javaagent.config.MeasurementUnitJsonProperty;
import org.hawkular.agent.javaagent.config.MetricTypeJsonProperty;
import org.hawkular.agent.javaagent.config.TimeUnits;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;
import org.hawkular.metrics.client.common.MetricType;
import org.shaded.jboss.as.controller.client.helpers.MeasurementUnit;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class DMRMetric
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty
    private String path = "/";
    @JsonProperty(required=true)
    private String attribute;
    @JsonProperty(value="resolve-expressions")
    private Boolean resolveExpressions = Boolean.FALSE;
    @JsonProperty(value="include-defaults")
    private Boolean includeDefaults = Boolean.TRUE;
    @JsonProperty
    private Integer interval = 5;
    @JsonProperty(value="time-units")
    private TimeUnits timeUnits = TimeUnits.minutes;
    @JsonProperty(value="metric-units")
    private MeasurementUnitJsonProperty metricUnits = new MeasurementUnitJsonProperty(MeasurementUnit.NONE);
    @JsonProperty(value="metric-type")
    private MetricTypeJsonProperty metricType = new MetricTypeJsonProperty(MetricType.GAUGE);
    @JsonProperty(value="metric-id-template")
    private String metricIdTemplate;
    @JsonProperty(value="metric-tags")
    private Map<String, String> metricTags;

    public DMRMetric() {
    }

    public DMRMetric(DMRMetric original) {
        this.name = original.name;
        this.path = original.path;
        this.attribute = original.attribute;
        this.resolveExpressions = original.resolveExpressions;
        this.includeDefaults = original.includeDefaults;
        this.interval = original.interval;
        this.timeUnits = original.timeUnits;
        this.metricUnits = original.metricUnits == null ? null : new MeasurementUnitJsonProperty(original.metricUnits);
        this.metricType = original.metricType == null ? null : new MetricTypeJsonProperty(original.metricType);
        this.metricIdTemplate = original.metricIdTemplate;
        this.metricTags = original.metricTags == null ? null : new HashMap<String, String>(original.metricTags);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("metric-dmr name must be specified");
        }
        if (this.attribute == null) {
            throw new Exception("metric-dmr [" + this.name + "] attribute must be specified");
        }
        if (this.interval == null || this.interval < 0) {
            throw new Exception("metric-dmr [" + this.name + "] interval must be greater than or equal to 0");
        }
        try {
            if (!"/".equals(this.path)) {
                WildflyCompatibilityUtils.parseCLIStyleAddress(this.path);
            }
        }
        catch (Exception e) {
            throw new Exception("metric-dmr [" + this.name + "] path [" + this.path + "] is invalid", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public Boolean getResolveExpressions() {
        return this.resolveExpressions;
    }

    public void setResolveExpressions(Boolean resolveExpressions) {
        this.resolveExpressions = resolveExpressions;
    }

    public Boolean getIncludeDefaults() {
        return this.includeDefaults;
    }

    public void setIncludeDefaults(Boolean includeDefaults) {
        this.includeDefaults = includeDefaults;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public TimeUnits getTimeUnits() {
        return this.timeUnits;
    }

    public void setTimeUnits(TimeUnits timeUnits) {
        this.timeUnits = timeUnits;
    }

    public MeasurementUnit getMetricUnits() {
        return this.metricUnits == null ? null : (MeasurementUnit)((Object)this.metricUnits.get());
    }

    public void setMetricUnits(MeasurementUnit mu) {
        if (this.metricUnits != null) {
            this.metricUnits.set(mu);
        } else {
            this.metricUnits = new MeasurementUnitJsonProperty(mu);
        }
    }

    public MetricType getMetricType() {
        return this.metricType == null ? null : (MetricType)((Object)this.metricType.get());
    }

    public void setMetricType(MetricType mt) {
        if (this.metricType != null) {
            this.metricType.set(mt);
        } else {
            this.metricType = new MetricTypeJsonProperty(mt);
        }
    }

    public String getMetricIdTemplate() {
        return this.metricIdTemplate;
    }

    public void setMetricIdTemplate(String metricIdTemplate) {
        this.metricIdTemplate = metricIdTemplate;
    }

    public Map<String, String> getMetricTags() {
        return this.metricTags;
    }

    public void setMetricTags(Map<String, String> metricTags) {
        this.metricTags = metricTags;
    }
}

