/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.shaded.fasterxml.jackson.annotation.JsonAutoDetect;
import com.shaded.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.hawkular.agent.javaagent.config.TimeUnits;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class JMXAvail
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty(value="object-name")
    private String objectName;
    @JsonProperty(required=true)
    private String attribute;
    @JsonProperty(value="up-regex")
    private String upRegex;
    @JsonProperty
    private Integer interval = 5;
    @JsonProperty(value="time-units")
    private TimeUnits timeUnits = TimeUnits.minutes;
    @JsonProperty(value="metric-id-template")
    private String metricIdTemplate;
    @JsonProperty(value="metric-tags")
    private Map<String, String> metricTags;

    public JMXAvail() {
    }

    public JMXAvail(JMXAvail original) {
        this.name = original.name;
        this.objectName = original.objectName;
        this.attribute = original.attribute;
        this.upRegex = original.upRegex;
        this.interval = original.interval;
        this.timeUnits = original.timeUnits;
        this.metricIdTemplate = original.metricIdTemplate;
        this.metricTags = original.metricTags == null ? null : new HashMap<String, String>(original.metricTags);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("avail-jmx name must be specified");
        }
        if (this.attribute == null) {
            throw new Exception("avail-jmx [" + this.name + "] attribute must be specified");
        }
        if (this.interval == null || this.interval < 0) {
            throw new Exception("avail-jmx [" + this.name + "] interval must be greater than or equal to 0");
        }
        if (this.objectName != null) {
            try {
                new ObjectName(this.objectName);
            }
            catch (Exception e) {
                throw new Exception("avail-jmx [" + this.name + "] object-name [" + this.objectName + "] is invalid", e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getUpRegex() {
        return this.upRegex;
    }

    public void setUpRegex(String upRegex) {
        this.upRegex = upRegex;
    }

    public Integer getInterval() {
        return this.interval;
    }

    public void setInterval(Integer interval) {
        this.interval = interval;
    }

    public TimeUnits getTimeUnits() {
        return this.timeUnits;
    }

    public void setTimeUnits(TimeUnits timeUnits) {
        this.timeUnits = timeUnits;
    }

    public String getMetricIdTemplate() {
        return this.metricIdTemplate;
    }

    public void setMetricIdTemplate(String metricIdTemplate) {
        this.metricIdTemplate = metricIdTemplate;
    }

    public Map<String, String> getMetricTags() {
        return this.metricTags;
    }

    public void setMetricTags(Map<String, String> metricTags) {
        this.metricTags = metricTags;
    }
}

