/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.shaded.fasterxml.jackson.annotation.JsonAutoDetect;
import com.shaded.fasterxml.jackson.annotation.JsonProperty;
import javax.management.ObjectName;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.JMXOperationParam;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class JMXOperation
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty(value="object-name")
    private String objectName;
    @JsonProperty(value="internal-name")
    private String internalName;
    @JsonProperty
    private Boolean modifies = Boolean.FALSE;
    @JsonProperty(value="params")
    private JMXOperationParam[] jmxOperationParams;

    public JMXOperation() {
    }

    public JMXOperation(JMXOperation original) {
        this.name = original.name;
        this.objectName = original.objectName;
        this.internalName = original.internalName;
        this.modifies = original.modifies;
        this.jmxOperationParams = Util.cloneArray(original.jmxOperationParams);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("operation-jmx name must be specified");
        }
        if (this.objectName != null) {
            try {
                new ObjectName(this.objectName);
            }
            catch (Exception e) {
                throw new Exception("operation-jmx [" + this.name + "] object-name [" + this.objectName + "] is invalid", e);
            }
        }
        if (this.jmxOperationParams != null) {
            for (JMXOperationParam o : this.jmxOperationParams) {
                o.validate();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public Boolean getModifies() {
        return this.modifies;
    }

    public void setModifies(Boolean modifies) {
        this.modifies = modifies;
    }

    public JMXOperationParam[] getJmxOperationParams() {
        return this.jmxOperationParams;
    }

    public void setJmxOperationParams(JMXOperationParam[] jmxOperationParams) {
        this.jmxOperationParams = jmxOperationParams;
    }
}

