/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.shaded.fasterxml.jackson.annotation.JsonAutoDetect;
import com.shaded.fasterxml.jackson.annotation.JsonProperty;
import javax.management.ObjectName;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class JMXResourceConfig
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty(value="object-name")
    private String objectName;
    @JsonProperty(required=true)
    private String attribute;

    public JMXResourceConfig() {
    }

    public JMXResourceConfig(JMXResourceConfig original) {
        this.name = original.name;
        this.objectName = original.objectName;
        this.attribute = original.attribute;
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("resource-config-jmx name must be specified");
        }
        if (this.attribute == null || this.attribute.trim().isEmpty()) {
            throw new Exception("resource-config-jmx [" + this.name + "] attribute must be specified");
        }
        if (this.objectName != null) {
            try {
                new ObjectName(this.objectName);
            }
            catch (Exception e) {
                throw new Exception("resource-config-jmx [" + this.name + "] object-name [" + this.objectName + "] is invalid", e);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }
}

