/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.shaded.fasterxml.jackson.annotation.JsonAutoDetect;
import com.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.Util;
import org.hawkular.agent.javaagent.config.JMXResourceType;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class JMXResourceTypeSet
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty
    private Boolean enabled = Boolean.TRUE;
    @JsonProperty(value="resource-type-jmx")
    private JMXResourceType[] jmxResourceTypes;

    public JMXResourceTypeSet() {
    }

    public JMXResourceTypeSet(JMXResourceTypeSet original) {
        this.name = original.name;
        this.enabled = original.enabled;
        this.jmxResourceTypes = Util.cloneArray(original.jmxResourceTypes);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("resource-type-set-jmx name must be specified");
        }
        if (this.jmxResourceTypes != null) {
            for (JMXResourceType o : this.jmxResourceTypes) {
                o.validate();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public JMXResourceType[] getJmxResourceTypes() {
        return this.jmxResourceTypes;
    }

    public void setJmxResourceTypes(JMXResourceType[] jmxResourceTypes) {
        this.jmxResourceTypes = jmxResourceTypes;
    }
}

