/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.shaded.fasterxml.jackson.annotation.JsonAutoDetect;
import com.shaded.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.agent.javaagent.config.BooleanExpression;
import org.hawkular.agent.javaagent.config.StringExpression;
import org.hawkular.agent.javaagent.config.Validatable;
import org.hawkular.agent.javaagent.config.WaitFor;
import org.hawkular.agent.monitor.api.Avail;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class LocalDMR
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty
    private BooleanExpression enabled = new BooleanExpression(Boolean.TRUE);
    @JsonProperty(value="tenant-id")
    private StringExpression tenantId;
    @JsonProperty(value="resource-type-sets")
    private String[] resourceTypeSets;
    @JsonProperty(value="metric-id-template")
    private String metricIdTemplate;
    @JsonProperty(value="metric-tags")
    private Map<String, String> metricTags;
    @JsonProperty(value="set-avail-on-shutdown")
    private Avail setAvailOnShutdown;
    @JsonProperty(value="wait-for")
    private WaitFor[] waitFor;

    public LocalDMR() {
    }

    public LocalDMR(LocalDMR original) {
        this.name = original.name;
        this.enabled = original.enabled == null ? null : new BooleanExpression(original.enabled);
        this.tenantId = original.tenantId == null ? null : new StringExpression(original.tenantId);
        this.resourceTypeSets = original.resourceTypeSets == null ? null : Arrays.copyOf(original.resourceTypeSets, original.resourceTypeSets.length);
        this.metricIdTemplate = original.metricIdTemplate;
        this.metricTags = original.metricTags == null ? null : new HashMap<String, String>(original.metricTags);
        this.setAvailOnShutdown = original.setAvailOnShutdown;
        this.waitFor = original.waitFor == null ? null : Arrays.copyOf(original.waitFor, original.waitFor.length);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("local-dmr name must be specified");
        }
        if (this.waitFor != null) {
            for (WaitFor wf : this.waitFor) {
                wf.validate();
                if ("/".equals(wf.getName())) continue;
                try {
                    WildflyCompatibilityUtils.parseCLIStyleAddress(wf.getName());
                }
                catch (Exception e) {
                    throw new Exception("local-dmr [" + this.name + "] has invalid wait-for resource: " + wf.getName(), e);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnabled() {
        return this.enabled == null ? null : (Boolean)this.enabled.get();
    }

    public void setEnabled(Boolean enabled) {
        if (this.enabled != null) {
            this.enabled.set(enabled);
        } else {
            this.enabled = new BooleanExpression(enabled);
        }
    }

    public String getTenantId() {
        return this.tenantId == null ? null : ((StringExpression.StringValue)this.tenantId.get()).toString();
    }

    public void setTenantId(String tenantId) {
        if (this.tenantId != null) {
            this.tenantId.set(new StringExpression.StringValue(tenantId));
        } else {
            this.tenantId = new StringExpression(tenantId);
        }
    }

    public String[] getResourceTypeSets() {
        return this.resourceTypeSets;
    }

    public void setResourceTypeSets(String[] resourceTypeSets) {
        this.resourceTypeSets = resourceTypeSets;
    }

    public String getMetricIdTemplate() {
        return this.metricIdTemplate;
    }

    public void setMetricIdTemplate(String metricIdTemplate) {
        this.metricIdTemplate = metricIdTemplate;
    }

    public Map<String, String> getMetricTags() {
        return this.metricTags;
    }

    public void setMetricTags(Map<String, String> metricTags) {
        this.metricTags = metricTags;
    }

    public Avail getSetAvailOnShutdown() {
        return this.setAvailOnShutdown;
    }

    public void setSetAvailOnShutdown(Avail setAvailOnShutdown) {
        this.setAvailOnShutdown = setAvailOnShutdown;
    }

    public WaitFor[] getWaitFor() {
        return this.waitFor;
    }

    public void setWaitFor(WaitFor[] waitFor) {
        this.waitFor = waitFor;
    }
}

