/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.shaded.fasterxml.jackson.annotation.JsonAutoDetect;
import com.shaded.fasterxml.jackson.annotation.JsonProperty;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.hawkular.agent.javaagent.config.StringExpression;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class SecurityRealm
implements Validatable {
    @JsonProperty(required=true)
    private String name;
    @JsonProperty(value="keystore-path", required=true)
    private StringExpression keystorePath;
    @JsonProperty(value="keystore-password", required=true)
    private StringExpression keystorePassword;
    @JsonProperty(value="key-password")
    private StringExpression keyPassword;
    @JsonProperty(value="keystore-type")
    private StringExpression keystoreType = new StringExpression(KeyStore.getDefaultType());
    @JsonProperty(value="key-manager-algorithm")
    private StringExpression keyManagerAlgorithm = new StringExpression(KeyManagerFactory.getDefaultAlgorithm());
    @JsonProperty(value="trust-manager-algorithm")
    private StringExpression trustManagerAlgorithm = new StringExpression(TrustManagerFactory.getDefaultAlgorithm());
    @JsonProperty(value="ssl-protocol")
    private StringExpression sslProtocol = new StringExpression("TLSv1");

    public SecurityRealm() {
    }

    public SecurityRealm(SecurityRealm original) {
        this.name = original.name;
        this.keystorePath = original.keystorePath == null ? null : new StringExpression(original.keystorePath);
        this.keystorePassword = original.keystorePassword == null ? null : new StringExpression(original.keystorePassword);
        this.keyPassword = original.keyPassword == null ? null : new StringExpression(original.keyPassword);
        this.keystoreType = original.keystoreType == null ? null : new StringExpression(original.keystoreType);
        this.keyManagerAlgorithm = original.keyManagerAlgorithm == null ? null : new StringExpression(original.keyManagerAlgorithm);
        this.trustManagerAlgorithm = original.trustManagerAlgorithm == null ? null : new StringExpression(original.trustManagerAlgorithm);
        this.sslProtocol = original.sslProtocol == null ? null : new StringExpression(original.sslProtocol);
    }

    @Override
    public void validate() throws Exception {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new Exception("security-realm name must be specified");
        }
        if (this.keystorePath == null || ((StringExpression.StringValue)this.keystorePath.get()).toString().trim().length() == 0) {
            throw new Exception("security-realm: [" + this.name + "] keystore-path must be specified");
        }
        if (this.keystorePassword == null || ((StringExpression.StringValue)this.keystorePassword.get()).toString().trim().length() == 0) {
            throw new Exception("security-realm: [" + this.name + "] keystore-password must be specified");
        }
        if (this.keystoreType == null) {
            throw new Exception("security-realm: [" + this.name + "] keystore-type must be specified");
        }
        try {
            KeyStore.getInstance(((StringExpression.StringValue)this.keystoreType.get()).toString());
        }
        catch (Exception e) {
            throw new Exception("security-realm: [" + this.name + "] keystore-type [" + this.keystoreType.get() + "] is invalid. You may want to use the VM default of [" + KeyStore.getDefaultType() + "]", e);
        }
        if (this.keyManagerAlgorithm == null) {
            throw new Exception("security-realm: [" + this.name + "] key-manager-algorithm must be specified");
        }
        try {
            KeyManagerFactory.getInstance(((StringExpression.StringValue)this.keyManagerAlgorithm.get()).toString());
        }
        catch (Exception e) {
            throw new Exception("security-realm: [" + this.name + "] key-manager-algorithm [" + this.keyManagerAlgorithm.get() + "] is invalid. You may want to use the VM default of [" + KeyManagerFactory.getDefaultAlgorithm() + "]", e);
        }
        if (this.trustManagerAlgorithm == null) {
            throw new Exception("security-realm: [" + this.name + "] trust-manager-algorithm must be specified");
        }
        try {
            TrustManagerFactory.getInstance(((StringExpression.StringValue)this.trustManagerAlgorithm.get()).toString());
        }
        catch (Exception e) {
            throw new Exception("security-realm: [" + this.name + "] trust-manager-algorithm [" + this.trustManagerAlgorithm.get() + "] is invalid. You may want to use the VM default of [" + TrustManagerFactory.getDefaultAlgorithm() + "]", e);
        }
        if (this.sslProtocol == null) {
            throw new Exception("security-realm: [" + this.name + "] ssl-protocol must be specified");
        }
        try {
            SSLContext.getInstance(((StringExpression.StringValue)this.sslProtocol.get()).toString());
        }
        catch (Exception e) {
            throw new Exception("security-realm: [" + this.name + "] ssl-protocol [" + this.sslProtocol.get() + "] is invalid. You may want to use [TLSv1]", e);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKeystorePath() {
        return this.keystorePath == null ? null : ((StringExpression.StringValue)this.keystorePath.get()).toString();
    }

    public void setKeystorePath(String keystorePath) {
        if (this.keystorePath != null) {
            this.keystorePath.set(new StringExpression.StringValue(keystorePath));
        } else {
            this.keystorePath = new StringExpression(new StringExpression.StringValue(keystorePath));
        }
    }

    public String getKeystorePassword() {
        return this.keystorePassword == null ? null : ((StringExpression.StringValue)this.keystorePassword.get()).toString();
    }

    public void setKeystorePassword(String keystorePassword) {
        if (this.keystorePassword != null) {
            this.keystorePassword.set(new StringExpression.StringValue(keystorePassword));
        } else {
            this.keystorePassword = new StringExpression(new StringExpression.StringValue(keystorePassword));
        }
    }

    public String getKeyPassword() {
        return this.keyPassword == null ? null : ((StringExpression.StringValue)this.keyPassword.get()).toString();
    }

    public void setKeyPassword(String keyPassword) {
        if (this.keyPassword != null) {
            this.keyPassword.set(new StringExpression.StringValue(keyPassword));
        } else {
            this.keyPassword = new StringExpression(new StringExpression.StringValue(keyPassword));
        }
    }

    public String getKeystoreType() {
        return this.keystoreType == null ? null : ((StringExpression.StringValue)this.keystoreType.get()).toString();
    }

    public void setKeystoreType(String keystoreType) {
        if (this.keystoreType != null) {
            this.keystoreType.set(new StringExpression.StringValue(keystoreType));
        } else {
            this.keystoreType = new StringExpression(new StringExpression.StringValue(keystoreType));
        }
    }

    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm == null ? null : ((StringExpression.StringValue)this.keyManagerAlgorithm.get()).toString();
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        if (this.keyManagerAlgorithm != null) {
            this.keyManagerAlgorithm.set(new StringExpression.StringValue(keyManagerAlgorithm));
        } else {
            this.keyManagerAlgorithm = new StringExpression(new StringExpression.StringValue(keyManagerAlgorithm));
        }
    }

    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm == null ? null : ((StringExpression.StringValue)this.trustManagerAlgorithm.get()).toString();
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        if (this.trustManagerAlgorithm != null) {
            this.trustManagerAlgorithm.set(new StringExpression.StringValue(trustManagerAlgorithm));
        } else {
            this.trustManagerAlgorithm = new StringExpression(new StringExpression.StringValue(trustManagerAlgorithm));
        }
    }

    public String getSslProtocol() {
        return this.sslProtocol == null ? null : ((StringExpression.StringValue)this.sslProtocol.get()).toString();
    }

    public void setSslProtocol(String sslProtocol) {
        if (this.sslProtocol != null) {
            this.sslProtocol.set(new StringExpression.StringValue(sslProtocol));
        } else {
            this.sslProtocol = new StringExpression(new StringExpression.StringValue(sslProtocol));
        }
    }
}

