/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.javaagent.config;

import com.shaded.fasterxml.jackson.annotation.JsonAutoDetect;
import com.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.hawkular.agent.javaagent.config.BooleanExpression;
import org.hawkular.agent.javaagent.config.IntegerExpression;
import org.hawkular.agent.javaagent.config.Validatable;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class Subsystem
implements Validatable {
    @JsonProperty
    private BooleanExpression enabled = new BooleanExpression(Boolean.TRUE);
    @JsonProperty(value="auto-discovery-scan-period-secs")
    private IntegerExpression autoDiscoveryScanPeriodSecs = new IntegerExpression(600);
    @JsonProperty(value="min-collection-interval-secs")
    private IntegerExpression minCollectionIntervalSecs = new IntegerExpression(30);
    @JsonProperty
    private BooleanExpression immutable = new BooleanExpression(Boolean.FALSE);
    @JsonProperty(value="in-container")
    private BooleanExpression inContainer = new BooleanExpression(Boolean.FALSE);
    @JsonProperty(value="metric-dispatcher-buffer-size")
    private Integer metricDispatcherBufferSize = 1000;
    @JsonProperty(value="metric-dispatcher-max-batch-size")
    private Integer metricDispatcherMaxBatchSize = 100;
    @JsonProperty(value="avail-dispatcher-buffer-size")
    private Integer availDispatcherBufferSize = 500;
    @JsonProperty(value="avail-dispatcher-max-batch-size")
    private Integer availDispatcherMaxBatchSize = 50;
    @JsonProperty(value="ping-period-secs")
    private IntegerExpression pingPeriodSecs = new IntegerExpression(60);

    public Subsystem() {
    }

    public Subsystem(Subsystem original) {
        this.enabled = original.enabled == null ? null : new BooleanExpression(original.enabled);
        this.autoDiscoveryScanPeriodSecs = original.autoDiscoveryScanPeriodSecs == null ? null : new IntegerExpression(original.autoDiscoveryScanPeriodSecs);
        this.minCollectionIntervalSecs = original.minCollectionIntervalSecs == null ? null : new IntegerExpression(original.minCollectionIntervalSecs);
        this.immutable = original.immutable == null ? null : new BooleanExpression(original.immutable);
        this.inContainer = original.inContainer == null ? null : new BooleanExpression(original.inContainer);
        this.metricDispatcherBufferSize = original.metricDispatcherBufferSize;
        this.metricDispatcherMaxBatchSize = original.metricDispatcherMaxBatchSize;
        this.availDispatcherBufferSize = original.availDispatcherBufferSize;
        this.availDispatcherMaxBatchSize = original.availDispatcherMaxBatchSize;
        this.pingPeriodSecs = original.pingPeriodSecs == null ? null : new IntegerExpression(original.pingPeriodSecs);
    }

    @Override
    public void validate() throws Exception {
        if (this.autoDiscoveryScanPeriodSecs != null && (Integer)this.autoDiscoveryScanPeriodSecs.get() <= 0) {
            throw new Exception("subsystem auto-discovery-scan-period-secs must be greater than 0");
        }
        if (this.minCollectionIntervalSecs != null && (Integer)this.minCollectionIntervalSecs.get() <= 0) {
            throw new Exception("subsystem min-collection-interval-secs must be greater than 0");
        }
        if (this.metricDispatcherBufferSize != null && this.metricDispatcherBufferSize <= 0) {
            throw new Exception("subsystem metric-dispatcher-buffer-size must be greater than 0");
        }
        if (this.metricDispatcherMaxBatchSize != null && this.metricDispatcherMaxBatchSize <= 0) {
            throw new Exception("subsystem metric-dispatcher-max-batch-size must be greater than 0");
        }
        if (this.availDispatcherBufferSize != null && this.availDispatcherBufferSize <= 0) {
            throw new Exception("subsystem avail-dispatcher-buffer-size must be greater than 0");
        }
        if (this.availDispatcherMaxBatchSize != null && this.availDispatcherMaxBatchSize <= 0) {
            throw new Exception("subsystem avail-dispatcher-max-batch-size must be greater than 0");
        }
        if (this.pingPeriodSecs != null && (Integer)this.pingPeriodSecs.get() < 0) {
            throw new Exception("subsystem ping-period-secs must be greater than or equal to 0");
        }
    }

    public Boolean getEnabled() {
        return this.enabled == null ? null : (Boolean)this.enabled.get();
    }

    public void setEnabled(Boolean enabled) {
        if (this.enabled != null) {
            this.enabled.set(enabled);
        } else {
            this.enabled = new BooleanExpression(enabled);
        }
    }

    public Integer getAutoDiscoveryScanPeriodSecs() {
        return this.autoDiscoveryScanPeriodSecs == null ? null : (Integer)this.autoDiscoveryScanPeriodSecs.get();
    }

    public void setAutoDiscoveryScanPeriodSecs(Integer autoDiscoveryScanPeriodSecs) {
        if (this.autoDiscoveryScanPeriodSecs != null) {
            this.autoDiscoveryScanPeriodSecs.set(autoDiscoveryScanPeriodSecs);
        } else {
            this.autoDiscoveryScanPeriodSecs = new IntegerExpression(autoDiscoveryScanPeriodSecs);
        }
    }

    public Integer getMinCollectionIntervalSecs() {
        return this.minCollectionIntervalSecs == null ? null : (Integer)this.minCollectionIntervalSecs.get();
    }

    public void setMinCollectionIntervalSecs(Integer minCollectionIntervalSecs) {
        if (this.minCollectionIntervalSecs != null) {
            this.minCollectionIntervalSecs.set(minCollectionIntervalSecs);
        } else {
            this.minCollectionIntervalSecs = new IntegerExpression(minCollectionIntervalSecs);
        }
    }

    public Boolean getImmutable() {
        return this.immutable == null ? null : (Boolean)this.immutable.get();
    }

    public void setImmutable(Boolean immutable) {
        if (this.immutable != null) {
            this.immutable.set(immutable);
        } else {
            this.immutable = new BooleanExpression(immutable);
        }
    }

    public Boolean getInContainer() {
        return this.inContainer == null ? null : (Boolean)this.inContainer.get();
    }

    public void setInContainer(Boolean inContainer) {
        if (this.inContainer != null) {
            this.inContainer.set(inContainer);
        } else {
            this.inContainer = new BooleanExpression(inContainer);
        }
    }

    public Integer getMetricDispatcherBufferSize() {
        return this.metricDispatcherBufferSize;
    }

    public void setMetricDispatcherBufferSize(Integer metricDispatcherBufferSize) {
        this.metricDispatcherBufferSize = metricDispatcherBufferSize;
    }

    public Integer getMetricDispatcherMaxBatchSize() {
        return this.metricDispatcherMaxBatchSize;
    }

    public void setMetricDispatcherMaxBatchSize(Integer metricDispatcherMaxBatchSize) {
        this.metricDispatcherMaxBatchSize = metricDispatcherMaxBatchSize;
    }

    public Integer getAvailDispatcherBufferSize() {
        return this.availDispatcherBufferSize;
    }

    public void setAvailDispatcherBufferSize(Integer availDispatcherBufferSize) {
        this.availDispatcherBufferSize = availDispatcherBufferSize;
    }

    public Integer getAvailDispatcherMaxBatchSize() {
        return this.availDispatcherMaxBatchSize;
    }

    public void setAvailDispatcherMaxBatchSize(Integer availDispatcherMaxBatchSize) {
        this.availDispatcherMaxBatchSize = availDispatcherMaxBatchSize;
    }

    public Integer getPingPeriodSecs() {
        return this.pingPeriodSecs == null ? null : (Integer)this.pingPeriodSecs.get();
    }

    public void setPingPeriodSecs(Integer pingPeriodSecs) {
        if (this.pingPeriodSecs != null) {
            this.pingPeriodSecs.set(pingPeriodSecs);
        } else {
            this.pingPeriodSecs = new IntegerExpression(pingPeriodSecs);
        }
    }
}

