/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.hawkular.agent.monitor.cmd.AbstractDMRResourcePathCommand;
import org.hawkular.agent.monitor.cmd.AbstractJMXResourcePathCommand;
import org.hawkular.agent.monitor.cmd.AbstractResourcePathCommand;
import org.hawkular.agent.monitor.cmd.Command;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.InventoryIdUtil;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.cmdgw.api.MessageUtils;
import org.hawkular.cmdgw.api.ResourcePathRequest;
import org.hawkular.cmdgw.api.ResourcePathResponse;
import org.hawkular.cmdgw.api.ResponseStatus;
import org.hawkular.inventory.paths.CanonicalPath;

public abstract class AbstractAgnosticResourcePathCommand<REQ extends ResourcePathRequest, RESP extends ResourcePathResponse>
extends AbstractResourcePathCommand<REQ, RESP>
implements Command<REQ, RESP> {
    private static final MsgLogger log = AgentLoggers.getLogger(AbstractAgnosticResourcePathCommand.class);

    public AbstractAgnosticResourcePathCommand(String operationName, String entityType) {
        super(operationName, entityType);
    }

    @Override
    public BasicMessageWithExtraData<RESP> execute(BasicMessageWithExtraData<REQ> envelope, CommandContext context) throws Exception {
        ResourcePathRequest request = (ResourcePathRequest)envelope.getBasicMessage();
        String rawResourcePath = request.getResourcePath();
        long timestampBeforeExecution = System.currentTimeMillis();
        try {
            String resourceId;
            this.validate(envelope);
            CanonicalPath canonicalPath = CanonicalPath.fromString(rawResourcePath);
            try {
                resourceId = canonicalPath.ids().getResourcePath().getSegment().getElementId();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Bad resource path specified in command: " + rawResourcePath);
            }
            InventoryIdUtil.ResourceIdParts idParts = InventoryIdUtil.parseResourceId(resourceId);
            String managedServerName = idParts.getManagedServerName();
            boolean isDmr = context.getAgentCoreEngine().getProtocolServices().getDmrProtocolService().getEndpointServices().containsKey(managedServerName);
            if (isDmr) {
                return this.getDMRCommand().execute(envelope, context);
            }
            boolean isJmx = context.getAgentCoreEngine().getProtocolServices().getJmxProtocolService().getEndpointServices().containsKey(managedServerName);
            if (isJmx) {
                return this.getJMXCommand().execute(envelope, context);
            }
            throw new IllegalArgumentException(String.format("Cannot perform [%s] on a [%s] given by inventory path [%s]: unknown managed server [%s]", this.getOperationName(envelope), this.getEntityType(envelope), idParts.getIdPart(), managedServerName));
        }
        catch (Throwable t) {
            Object response = this.createResponse();
            MessageUtils.prepareResourcePathResponse(request, response);
            ((ResourcePathResponse)response).setStatus(ResponseStatus.ERROR);
            String formattedTimestamp = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mmX").withZone(ZoneOffset.UTC).format(Instant.ofEpochMilli(timestampBeforeExecution));
            String msg = String.format("Could not perform [%s] on a [%s] given by inventory path [%s] requested on [%s]: %s", this.getOperationName(envelope), this.getEntityType(envelope), rawResourcePath, formattedTimestamp, t.toString());
            ((ResourcePathResponse)response).setMessage(msg);
            log.debug(msg, t);
            return new BasicMessageWithExtraData(response, null);
        }
    }

    @Override
    protected void validate(BasicMessageWithExtraData<REQ> envelope, MonitoredEndpoint<? extends AgentCoreEngineConfiguration.AbstractEndpointConfiguration> endpoint) {
        throw new UnsupportedOperationException("This is not to be used - use one of the DMR or JMX command objects");
    }

    protected abstract AbstractDMRResourcePathCommand<REQ, RESP> getDMRCommand();

    protected abstract AbstractJMXResourcePathCommand<REQ, RESP> getJMXCommand();
}

