/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hawkular.agent.monitor.cmd.AbstractDMRResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.DisableApplicationRequest;
import org.hawkular.cmdgw.api.DisableApplicationResponse;
import org.hawkular.cmdgw.api.MessageUtils;
import org.hawkular.dmrclient.DeploymentJBossASClient;
import org.hawkular.inventory.paths.CanonicalPath;
import org.shaded.jboss.as.controller.client.ModelControllerClient;

public class DisableApplicationCommand
extends AbstractDMRResourcePathCommand<DisableApplicationRequest, DisableApplicationResponse> {
    private static final MsgLogger log = AgentLoggers.getLogger(DisableApplicationCommand.class);
    public static final Class<DisableApplicationRequest> REQUEST_CLASS = DisableApplicationRequest.class;
    public static final String NAME = "Disable Deployment";

    public DisableApplicationCommand() {
        super(NAME, "Application");
    }

    @Override
    protected BinaryData execute(ModelControllerClient controllerClient, EndpointService<DMRNodeLocation, DMRSession> endpointService, String modelNodePath, BasicMessageWithExtraData<DisableApplicationRequest> envelope, DisableApplicationResponse response, CommandContext context, DMRSession dmrContext) throws Exception {
        DisableApplicationRequest request = envelope.getBasicMessage();
        String resourcePath = request.getResourcePath();
        String destFileName = request.getDestinationFileName();
        Set<String> serverGroups = this.convertCsvToSet(request.getServerGroups());
        CanonicalPath canonicalPath = CanonicalPath.fromString(request.getResourcePath());
        String resourceId = canonicalPath.ids().getResourcePath().getSegment().getElementId();
        ResourceManager<DMRNodeLocation> resourceManager = endpointService.getResourceManager();
        Resource<DMRNodeLocation> resource = resourceManager.getResource(new ID(resourceId));
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Cannot disable application: unknown resource [%s]", resourcePath));
        }
        Collection<Operation<DMRNodeLocation>> ops = resource.getResourceType().getOperations();
        boolean canPerform = false;
        log.tracef("Searching for [%s] operation among operations [%s] for resource [%s].", (Object)NAME, (Object)ops, (Object)resource.getID());
        for (Operation<DMRNodeLocation> op : ops) {
            if (!NAME.equals(op.getName().getNameString())) continue;
            canPerform = true;
            break;
        }
        if (!canPerform) {
            throw new IllegalArgumentException(String.format("Cannot [%s] from [%s]. The operation is undefined.", NAME, resource));
        }
        MessageUtils.prepareResourcePathResponse(request, response);
        response.setDestinationFileName(request.getDestinationFileName());
        DeploymentJBossASClient client = new DeploymentJBossASClient(dmrContext.getClient());
        client.disableDeployment(destFileName, serverGroups);
        endpointService.discoverAll();
        return null;
    }

    private Set<String> convertCsvToSet(String serverGroups) {
        if (serverGroups == null || serverGroups.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(serverGroups.split(",")));
    }

    @Override
    protected void validate(String modelNodePath, BasicMessageWithExtraData<DisableApplicationRequest> envelope) {
    }

    @Override
    protected void validate(BasicMessageWithExtraData<DisableApplicationRequest> envelope, MonitoredEndpoint<? extends AgentCoreEngineConfiguration.AbstractEndpointConfiguration> endpoint) {
    }

    @Override
    protected DisableApplicationResponse createResponse() {
        return new DisableApplicationResponse();
    }
}

