/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.util.Collection;
import java.util.Map;
import org.hawkular.agent.monitor.cmd.AbstractDMRResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.ExecuteOperationRequest;
import org.hawkular.cmdgw.api.ExecuteOperationResponse;
import org.hawkular.dmr.api.OperationBuilder;
import org.hawkular.inventory.paths.CanonicalPath;
import org.shaded.jboss.as.controller.client.ModelControllerClient;

public class ExecuteDMROperationCommand
extends AbstractDMRResourcePathCommand<ExecuteOperationRequest, ExecuteOperationResponse> {
    private static final MsgLogger log = AgentLoggers.getLogger(ExecuteDMROperationCommand.class);

    public ExecuteDMROperationCommand() {
        super("Execute Operation", "DMR Node");
    }

    @Override
    protected ExecuteOperationResponse createResponse() {
        return new ExecuteOperationResponse();
    }

    @Override
    protected String getOperationName(BasicMessageWithExtraData<ExecuteOperationRequest> envelope) {
        return envelope.getBasicMessage().getOperationName();
    }

    @Override
    protected void validate(String modelNodePath, BasicMessageWithExtraData<ExecuteOperationRequest> envelope) {
    }

    @Override
    protected void validate(BasicMessageWithExtraData<ExecuteOperationRequest> envelope, MonitoredEndpoint<? extends AgentCoreEngineConfiguration.AbstractEndpointConfiguration> endpoint) {
    }

    @Override
    protected boolean modifiesResource() {
        return false;
    }

    @Override
    protected BinaryData execute(ModelControllerClient controllerClient, EndpointService<DMRNodeLocation, DMRSession> endpointService, String modelNodePath, BasicMessageWithExtraData<ExecuteOperationRequest> envelope, ExecuteOperationResponse response, CommandContext context, DMRSession dmrContext) throws Exception {
        ExecuteOperationRequest request = envelope.getBasicMessage();
        CanonicalPath canonicalPath = CanonicalPath.fromString(request.getResourcePath());
        String resourceId = canonicalPath.ids().getResourcePath().getSegment().getElementId();
        ResourceManager<DMRNodeLocation> resourceManager = endpointService.getResourceManager();
        Resource<DMRNodeLocation> resource = resourceManager.getResource(new ID(resourceId));
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Cannot execute operation: unknown resource [%s]", request.getResourcePath()));
        }
        DMRNodeLocation opLocation = null;
        String actualOperationName = null;
        String requestedOpName = request.getOperationName();
        Collection<Operation<DMRNodeLocation>> ops = resource.getResourceType().getOperations();
        log.tracef("Searching for operation [%s] among operations [%s] for resource [%s].", (Object)requestedOpName, (Object)ops, (Object)resource.getID());
        for (Operation<DMRNodeLocation> op : ops) {
            if (!requestedOpName.equals(op.getName().getNameString())) continue;
            opLocation = (DMRNodeLocation)dmrContext.getLocationResolver().absolutize(resource.getLocation(), op.getLocation());
            actualOperationName = op.getInternalName();
            if (!op.getModifies() || !context.getAgentCoreEngine().isImmutable()) break;
            throw new IllegalStateException("Operation [" + requestedOpName + "] not allowed because the agent is immutable");
        }
        if (opLocation == null) {
            throw new IllegalArgumentException(String.format("Cannot execute operation: unknown operation [%s] for resource [%s]", request.getOperationName(), resource));
        }
        response.setOperationName(request.getOperationName());
        OperationBuilder.ByNameOperationBuilder operation = (OperationBuilder.ByNameOperationBuilder)OperationBuilder.byName(actualOperationName).address(opLocation.getPathAddress());
        Map<String, String> params = request.getParameters();
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                operation.attribute(param.getKey(), param.getValue());
            }
        }
        Object opResult = ((OperationBuilder.OperationResult)operation.execute(controllerClient)).assertSuccess();
        this.setServerRefreshIndicator((OperationBuilder.OperationResult<?>)opResult, response);
        endpointService.discoverAll();
        return null;
    }
}

