/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.cmd;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hawkular.agent.monitor.cmd.AbstractDMRResourcePathCommand;
import org.hawkular.agent.monitor.cmd.CommandContext;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.protocol.EndpointService;
import org.hawkular.agent.monitor.protocol.dmr.DMRNodeLocation;
import org.hawkular.agent.monitor.protocol.dmr.DMRSession;
import org.hawkular.bus.common.BasicMessageWithExtraData;
import org.hawkular.bus.common.BinaryData;
import org.hawkular.cmdgw.api.MessageUtils;
import org.hawkular.cmdgw.api.UndeployApplicationRequest;
import org.hawkular.cmdgw.api.UndeployApplicationResponse;
import org.hawkular.dmrclient.DeploymentJBossASClient;
import org.hawkular.inventory.paths.CanonicalPath;
import org.shaded.jboss.as.controller.client.ModelControllerClient;

public class UndeployApplicationCommand
extends AbstractDMRResourcePathCommand<UndeployApplicationRequest, UndeployApplicationResponse> {
    private static final MsgLogger log = AgentLoggers.getLogger(UndeployApplicationCommand.class);
    public static final Class<UndeployApplicationRequest> REQUEST_CLASS = UndeployApplicationRequest.class;

    public UndeployApplicationCommand() {
        super("Undeploy", "Application");
    }

    @Override
    protected BinaryData execute(ModelControllerClient controllerClient, EndpointService<DMRNodeLocation, DMRSession> endpointService, String modelNodePath, BasicMessageWithExtraData<UndeployApplicationRequest> envelope, UndeployApplicationResponse response, CommandContext context, DMRSession dmrContext) throws Exception {
        UndeployApplicationRequest request = envelope.getBasicMessage();
        String resourcePath = request.getResourcePath();
        String destFileName = request.getDestinationFileName();
        boolean removeContent = request.getRemoveContent() == null ? true : request.getRemoveContent();
        Set<String> serverGroups = this.convertCsvToSet(request.getServerGroups());
        CanonicalPath canonicalPath = CanonicalPath.fromString(request.getResourcePath());
        String resourceId = canonicalPath.ids().getResourcePath().getSegment().getElementId();
        ResourceManager<DMRNodeLocation> resourceManager = endpointService.getResourceManager();
        Resource<DMRNodeLocation> resource = resourceManager.getResource(new ID(resourceId));
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Cannot undeploy application: unknown resource [%s]", resourcePath));
        }
        Collection<Operation<DMRNodeLocation>> ops = resource.getResourceType().getOperations();
        boolean canUndeploy = false;
        log.tracef("Searching for Undeploy operation among operations [%s] for resource [%s].", (Object)ops, (Object)resource.getID());
        for (Operation<DMRNodeLocation> op : ops) {
            if (!"Undeploy".equals(op.getName().getNameString())) continue;
            canUndeploy = true;
            break;
        }
        if (!canUndeploy) {
            throw new IllegalArgumentException(String.format("Cannot undeploy application from [%s]. That feature is disabled.", resource));
        }
        MessageUtils.prepareResourcePathResponse(request, response);
        response.setDestinationFileName(request.getDestinationFileName());
        DeploymentJBossASClient client = new DeploymentJBossASClient(dmrContext.getClient());
        client.undeploy(destFileName, serverGroups, removeContent);
        endpointService.discoverAll();
        return null;
    }

    private Set<String> convertCsvToSet(String serverGroups) {
        if (serverGroups == null || serverGroups.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(serverGroups.split(",")));
    }

    @Override
    protected void validate(String modelNodePath, BasicMessageWithExtraData<UndeployApplicationRequest> envelope) {
    }

    @Override
    protected void validate(BasicMessageWithExtraData<UndeployApplicationRequest> envelope, MonitoredEndpoint<? extends AgentCoreEngineConfiguration.AbstractEndpointConfiguration> endpoint) {
    }

    @Override
    protected UndeployApplicationResponse createResponse() {
        return new UndeployApplicationResponse();
    }
}

