/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.diagnostics;

import com.shaded.codahale.metrics.Counter;
import com.shaded.codahale.metrics.Gauge;
import com.shaded.codahale.metrics.Histogram;
import com.shaded.codahale.metrics.Meter;
import com.shaded.codahale.metrics.Metric;
import com.shaded.codahale.metrics.MetricFilter;
import com.shaded.codahale.metrics.MetricRegistry;
import com.shaded.codahale.metrics.ScheduledReporter;
import com.shaded.codahale.metrics.Snapshot;
import com.shaded.codahale.metrics.Timer;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class JBossLoggingReporter
extends ScheduledReporter {
    private final LoggerProxy loggerProxy;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private JBossLoggingReporter(MetricRegistry registry, LoggerProxy loggerProxy, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, "hawkular-monitor", filter, rateUnit, durationUnit);
        this.loggerProxy = loggerProxy;
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        if (!this.loggerProxy.isEnabled()) {
            return;
        }
        StringBuilder logMessage = new StringBuilder("DIAGNOSTICS:\n==========\n");
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            logMessage.append(this.logGauge(entry.getKey(), entry.getValue()));
            logMessage.append("\n");
        }
        for (Map.Entry<String, Metric> entry : counters.entrySet()) {
            logMessage.append(this.logCounter(entry.getKey(), (Counter)entry.getValue()));
            logMessage.append("\n");
        }
        for (Map.Entry<String, Metric> entry : histograms.entrySet()) {
            logMessage.append(this.logHistogram(entry.getKey(), (Histogram)entry.getValue()));
            logMessage.append("\n");
        }
        for (Map.Entry<String, Metric> entry : meters.entrySet()) {
            logMessage.append(this.logMeter(entry.getKey(), (Meter)entry.getValue()));
            logMessage.append("\n");
        }
        for (Map.Entry<String, Metric> entry : timers.entrySet()) {
            logMessage.append(this.logTimer(entry.getKey(), (Timer)entry.getValue()));
            logMessage.append("\n");
        }
        logMessage.append("==========");
        this.loggerProxy.log(logMessage.toString(), new Object[0]);
    }

    private String logTimer(String name, Timer timer) {
        Snapshot snapshot = timer.getSnapshot();
        return String.format("%s: type=[timer], count=[%d], min=[%f], max=[%f], mean=[%f], stddev=[%f], median=[%f], p75=[%f], p95=[%f], p98=[%f], p99=[%f], p999=[%f], mean_rate=[%f], m1=[%f], m5=[%f], m15=[%f], rate_unit=[%s], duration_unit=[%s]", name, timer.getCount(), this.convertDuration(snapshot.getMin()), this.convertDuration(snapshot.getMax()), this.convertDuration(snapshot.getMean()), this.convertDuration(snapshot.getStdDev()), this.convertDuration(snapshot.getMedian()), this.convertDuration(snapshot.get75thPercentile()), this.convertDuration(snapshot.get95thPercentile()), this.convertDuration(snapshot.get98thPercentile()), this.convertDuration(snapshot.get99thPercentile()), this.convertDuration(snapshot.get999thPercentile()), this.convertRate(timer.getMeanRate()), this.convertRate(timer.getOneMinuteRate()), this.convertRate(timer.getFiveMinuteRate()), this.convertRate(timer.getFifteenMinuteRate()), this.getRateUnit(), this.getDurationUnit());
    }

    private String logMeter(String name, Meter meter) {
        return String.format("%s: type=[meter], count=[%d], mean_rate=[%f], m1=[%f], m5=[%f], m15=[%f], rate_unit=[%s]", name, meter.getCount(), this.convertRate(meter.getMeanRate()), this.convertRate(meter.getOneMinuteRate()), this.convertRate(meter.getFiveMinuteRate()), this.convertRate(meter.getFifteenMinuteRate()), this.getRateUnit());
    }

    private String logHistogram(String name, Histogram histogram) {
        Snapshot snapshot = histogram.getSnapshot();
        return String.format("%s: type=[histogram], count=[%d], min=[%d], max=[%d], mean=[%f], stddev=[%f], median=[%f], p75=[%f], p95=[%f], p98=[%f], p99=[%f], p999=[%f]", name, histogram.getCount(), snapshot.getMin(), snapshot.getMax(), snapshot.getMean(), snapshot.getStdDev(), snapshot.getMedian(), snapshot.get75thPercentile(), snapshot.get95thPercentile(), snapshot.get98thPercentile(), snapshot.get99thPercentile(), snapshot.get999thPercentile());
    }

    private String logCounter(String name, Counter counter) {
        return String.format("%s: type=[counter], count=[%d]", name, counter.getCount());
    }

    private String logGauge(String name, Gauge gauge) {
        return String.format("%s: type=[gauge], value=[%s]", name, gauge.getValue());
    }

    @Override
    protected String getRateUnit() {
        return "events/" + super.getRateUnit();
    }

    private static class InfoLoggerProxy
    extends LoggerProxy {
        public InfoLoggerProxy(Logger logger2) {
            super(logger2);
        }

        @Override
        public void log(String format, Object ... arguments) {
            this.logger.infof(format, arguments);
        }

        @Override
        boolean isEnabled() {
            return this.logger.isInfoEnabled();
        }
    }

    private static class TraceLoggerProxy
    extends LoggerProxy {
        public TraceLoggerProxy(Logger logger2) {
            super(logger2);
        }

        @Override
        public void log(String format, Object ... arguments) {
            this.logger.tracef(format, arguments);
        }

        @Override
        boolean isEnabled() {
            return this.logger.isTraceEnabled();
        }
    }

    private static class DebugLoggerProxy
    extends LoggerProxy {
        public DebugLoggerProxy(Logger logger2) {
            super(logger2);
        }

        @Override
        public void log(String format, Object ... arguments) {
            this.logger.debugf(format, arguments);
        }

        @Override
        boolean isEnabled() {
            return this.logger.isDebugEnabled();
        }
    }

    static abstract class LoggerProxy {
        protected final Logger logger;

        public LoggerProxy(Logger logger2) {
            this.logger = logger2;
        }

        abstract void log(String var1, Object ... var2);

        abstract boolean isEnabled();
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Logger logger;
        private LoggingLevel loggingLevel;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.logger = Logger.getLogger(JBossLoggingReporter.class);
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.loggingLevel = LoggingLevel.INFO;
        }

        public Builder outputTo(Logger logger2) {
            this.logger = logger2;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withLoggingLevel(LoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public JBossLoggingReporter build() {
            LoggerProxy loggerProxy;
            switch (this.loggingLevel) {
                case TRACE: {
                    loggerProxy = new TraceLoggerProxy(this.logger);
                    break;
                }
                case INFO: {
                    loggerProxy = new InfoLoggerProxy(this.logger);
                    break;
                }
                default: {
                    loggerProxy = new DebugLoggerProxy(this.logger);
                }
            }
            return new JBossLoggingReporter(this.registry, loggerProxy, this.rateUnit, this.durationUnit, this.filter);
        }
    }

    public static enum LoggingLevel {
        TRACE,
        DEBUG,
        INFO;

    }
}

