/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.dmr;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.hawkular.agent.monitor.inventory.ConnectionData;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.util.ThreadFactoryGenerator;
import org.shaded.jboss.as.controller.ModelController;
import org.shaded.jboss.as.controller.client.ModelControllerClient;
import org.shaded.jboss.as.controller.client.ModelControllerClientConfiguration;

public abstract class ModelControllerClientFactory {
    public static ModelControllerClientFactory createLocal(ModelController modelController) {
        return new LocalModelControllerClientFactory(modelController);
    }

    public static ModelControllerClientFactory createRemote(MonitoredEndpoint endpoint) {
        return new RemoteModelControllerClientFactory(endpoint);
    }

    public abstract ModelControllerClient createClient();

    private static class RemoteModelControllerClientFactory
    extends ModelControllerClientFactory {
        private final MonitoredEndpoint defaultEndpoint;

        public RemoteModelControllerClientFactory(MonitoredEndpoint endpoint) {
            this.defaultEndpoint = endpoint;
        }

        @Override
        public ModelControllerClient createClient() {
            return this.createClient(this.defaultEndpoint);
        }

        protected ModelControllerClient createClient(MonitoredEndpoint endpoint) {
            final ConnectionData cnData = endpoint.getConnectionData();
            CallbackHandler callbackHandler = new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback current : callbacks) {
                        if (current instanceof NameCallback) {
                            NameCallback ncb = (NameCallback)current;
                            ncb.setName(cnData.getUsername());
                            continue;
                        }
                        if (current instanceof PasswordCallback) {
                            PasswordCallback pcb = (PasswordCallback)current;
                            pcb.setPassword(cnData.getPassword().toCharArray());
                            continue;
                        }
                        if (current instanceof RealmCallback) {
                            RealmCallback rcb = (RealmCallback)current;
                            rcb.setText(rcb.getDefaultText());
                            continue;
                        }
                        throw new UnsupportedCallbackException(current);
                    }
                }
            };
            URI uri = cnData.getUri();
            try {
                ModelControllerClientConfiguration config = new ModelControllerClientConfiguration.Builder().setProtocol(uri.getScheme()).setHostName(uri.getHost()).setPort(uri.getPort()).setSslContext(endpoint.getSSLContext()).setHandler(callbackHandler).build();
                return ModelControllerClient.Factory.create(config);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create management client", e);
            }
        }
    }

    private static class LocalModelControllerClientFactory
    extends ModelControllerClientFactory {
        private final ModelController modelController;
        private Executor executor;

        public LocalModelControllerClientFactory(ModelController modelController) {
            this.modelController = modelController;
            ThreadFactory threadFactory = ThreadFactoryGenerator.generateFactory(true, "Hawkular-WildFly-Agent-LocalMgmtClient");
            this.executor = Executors.newCachedThreadPool(threadFactory);
        }

        @Override
        public ModelControllerClient createClient() {
            return this.modelController.createClient(this.executor);
        }
    }
}

