/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.protocol.platform;

import com.shaded.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.agent.monitor.diagnostics.ProtocolDiagnostics;
import org.hawkular.agent.monitor.inventory.AttributeLocation;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.protocol.Driver;
import org.hawkular.agent.monitor.protocol.ProtocolException;
import org.hawkular.agent.monitor.protocol.platform.OshiPlatformCache;
import org.hawkular.agent.monitor.protocol.platform.PlatformLocationResolver;
import org.hawkular.agent.monitor.protocol.platform.PlatformNodeLocation;
import org.hawkular.agent.monitor.protocol.platform.PlatformPath;
import org.hawkular.agent.monitor.protocol.platform.PlatformResourceNode;

public class PlatformDriver
implements Driver<PlatformNodeLocation> {
    private final OshiPlatformCache platform;
    private final ProtocolDiagnostics diagnostics;

    public PlatformDriver(OshiPlatformCache platform, ProtocolDiagnostics diagnostics) {
        this.platform = platform;
        this.diagnostics = diagnostics;
    }

    @Override
    public Map<PlatformNodeLocation, PlatformResourceNode> fetchNodes(PlatformNodeLocation location) throws ProtocolException {
        try {
            Map<PlatformPath, PlatformResourceNode> children = this.platform.discoverResources(location.getPlatformPath());
            HashMap<PlatformNodeLocation, PlatformResourceNode> result = new HashMap<PlatformNodeLocation, PlatformResourceNode>();
            for (Map.Entry<PlatformPath, PlatformResourceNode> en : children.entrySet()) {
                result.put(new PlatformNodeLocation(en.getKey()), en.getValue());
            }
            return Collections.unmodifiableMap(result);
        }
        catch (Exception e) {
            throw new ProtocolException(e);
        }
    }

    @Override
    public boolean attributeExists(AttributeLocation<PlatformNodeLocation> location) throws ProtocolException {
        Map<PlatformPath, PlatformResourceNode> nodes = this.platform.discoverResources(location.getLocation().getPlatformPath());
        switch (nodes.size()) {
            case 0: {
                return false;
            }
            case 1: {
                ID attributeToCheck = new ID(location.getAttribute());
                if ("Machine Id".equals(attributeToCheck.getIDString())) {
                    return true;
                }
                if ("Container Id".equals(attributeToCheck.getIDString())) {
                    return true;
                }
                return nodes.values().iterator().next().getType().getMetricTypeIds().contains(attributeToCheck);
            }
        }
        throw new ProtocolException("Platform Path [" + location.getLocation().getPlatformPath() + "] is not unique");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object fetchAttribute(AttributeLocation<PlatformNodeLocation> location) throws ProtocolException {
        try {
            Map<PlatformPath, PlatformResourceNode> nodes = null;
            ID metricToCollect = new ID(location.getAttribute());
            try (Timer.Context timerContext = this.diagnostics.getRequestTimer().time();){
                this.platform.refresh();
                nodes = this.platform.discoverResources(location.getLocation().getPlatformPath());
                switch (nodes.size()) {
                    case 0: {
                        Object var6_7 = null;
                        return var6_7;
                    }
                    case 1: {
                        if ("Machine Id".equals(metricToCollect.getIDString())) {
                            String string = this.platform.getMachineId();
                            return string;
                        }
                        if ("Container Id".equals(metricToCollect.getIDString())) {
                            String string = this.platform.getContainerId();
                            return string;
                        }
                        Double d = this.platform.getMetric(nodes.values().iterator().next(), metricToCollect);
                        return d;
                    }
                }
                ArrayList<Object> results = new ArrayList<Object>(nodes.size());
                for (PlatformResourceNode node : nodes.values()) {
                    if ("Machine Id".equals(metricToCollect.getIDString())) {
                        results.add(this.platform.getMachineId());
                        continue;
                    }
                    if ("Container Id".equals(metricToCollect.getIDString())) {
                        results.add(this.platform.getContainerId());
                        continue;
                    }
                    results.add(this.platform.getMetric(node, metricToCollect));
                }
                List list = Collections.unmodifiableList(results);
                return list;
            }
        }
        catch (Exception e) {
            this.diagnostics.getErrorRate().mark(1L);
            throw new ProtocolException(e);
        }
    }

    @Override
    public Map<PlatformNodeLocation, Object> fetchAttributeAsMap(AttributeLocation<PlatformNodeLocation> location) throws ProtocolException {
        if (!new PlatformLocationResolver().isMultiTarget(location.getLocation())) {
            Object o = this.fetchAttribute(location);
            return Collections.singletonMap(location.getLocation(), o);
        }
        Map<PlatformNodeLocation, PlatformResourceNode> nodes = this.fetchNodes(location.getLocation());
        HashMap<PlatformNodeLocation, Object> attribsMap = new HashMap<PlatformNodeLocation, Object>(nodes.size());
        for (Map.Entry<PlatformNodeLocation, PlatformResourceNode> entry : nodes.entrySet()) {
            AttributeLocation<PlatformNodeLocation> platformLocation = new AttributeLocation<PlatformNodeLocation>(entry.getKey(), location.getAttribute());
            Object attribValue = this.fetchAttribute(platformLocation);
            attribsMap.put(entry.getKey(), attribValue);
        }
        return Collections.unmodifiableMap(attribsMap);
    }
}

