/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.scheduler;

import java.util.Collection;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.MeasurementType;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.scheduler.ScheduledMeasurementInstance;

public class ScheduledCollectionsQueue<L, T extends MeasurementType<L>> {
    private static final MsgLogger LOG = AgentLoggers.getLogger(ScheduledCollectionsQueue.class);
    private final PriorityQueue<ScheduledMeasurementInstance<L, T>> priorityQueue = new PriorityQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextExpectedCollectionTime() {
        PriorityQueue<ScheduledMeasurementInstance<L, T>> priorityQueue = this.priorityQueue;
        synchronized (priorityQueue) {
            ScheduledMeasurementInstance<L, T> nextScheduledMeasurement = this.priorityQueue.peek();
            if (nextScheduledMeasurement == null) {
                return Long.MIN_VALUE;
            }
            return nextScheduledMeasurement.getNextCollectionTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MeasurementInstance<L, T>> popNextScheduledSet() {
        HashSet<MeasurementInstance<L, T>> nextScheduledSet = new HashSet<MeasurementInstance<L, T>>();
        PriorityQueue<ScheduledMeasurementInstance<L, T>> priorityQueue = this.priorityQueue;
        synchronized (priorityQueue) {
            ScheduledMeasurementInstance<L, T> first = this.priorityQueue.peek();
            if (first == null || first.getNextCollectionTime() > System.currentTimeMillis()) {
                return nextScheduledSet;
            }
            ScheduledMeasurementInstance<L, T> next = first;
            long firstCollectionTime = first.getNextCollectionTime();
            while (next != null && next.getNextCollectionTime() == firstCollectionTime) {
                ScheduledMeasurementInstance<L, T> queueItem = this.priorityQueue.poll();
                nextScheduledSet.add(queueItem.getMeasurementInstance());
                queueItem.setNextCollectionTime();
                this.priorityQueue.offer(queueItem);
                LOG.debugf("Popped measurement off queue and rescheduled: %s", (Object)queueItem);
                next = this.priorityQueue.peek();
            }
        }
        return nextScheduledSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Collection<ScheduledMeasurementInstance<L, T>> schedules) {
        PriorityQueue<ScheduledMeasurementInstance<L, T>> priorityQueue = this.priorityQueue;
        synchronized (priorityQueue) {
            this.priorityQueue.addAll(schedules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unschedule(Collection<Resource<L>> resources) {
        PriorityQueue<ScheduledMeasurementInstance<L, T>> priorityQueue = this.priorityQueue;
        synchronized (priorityQueue) {
            this.priorityQueue.removeIf(mi -> resources.contains(mi.getResource()));
        }
    }
}

