/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.storage;

import com.shaded.codahale.metrics.Timer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import okhttp3.shaded.Call;
import okhttp3.shaded.Request;
import okhttp3.shaded.Response;
import org.hawkular.agent.monitor.api.InventoryEvent;
import org.hawkular.agent.monitor.api.InventoryStorage;
import org.hawkular.agent.monitor.config.AgentCoreEngineConfiguration;
import org.hawkular.agent.monitor.diagnostics.Diagnostics;
import org.hawkular.agent.monitor.inventory.AvailType;
import org.hawkular.agent.monitor.inventory.ID;
import org.hawkular.agent.monitor.inventory.IDObject;
import org.hawkular.agent.monitor.inventory.Instance;
import org.hawkular.agent.monitor.inventory.MeasurementInstance;
import org.hawkular.agent.monitor.inventory.MeasurementType;
import org.hawkular.agent.monitor.inventory.MetricType;
import org.hawkular.agent.monitor.inventory.MonitoredEndpoint;
import org.hawkular.agent.monitor.inventory.NamedObject;
import org.hawkular.agent.monitor.inventory.Operation;
import org.hawkular.agent.monitor.inventory.OperationParam;
import org.hawkular.agent.monitor.inventory.Resource;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyInstance;
import org.hawkular.agent.monitor.inventory.ResourceConfigurationPropertyType;
import org.hawkular.agent.monitor.inventory.ResourceManager;
import org.hawkular.agent.monitor.inventory.ResourceType;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.storage.HttpClientBuilder;
import org.hawkular.agent.monitor.storage.InventoryMetric;
import org.hawkular.agent.monitor.storage.MetricDefinition;
import org.hawkular.agent.monitor.util.Util;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.ExtendedInventoryStructure;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.DataRole;
import org.hawkular.inventory.paths.RelativePath;
import org.hawkular.inventory.paths.SegmentType;

public class AsyncInventoryStorage
implements InventoryStorage {
    private static final MsgLogger log = AgentLoggers.getLogger(AsyncInventoryStorage.class);
    private static final int CHUNKS_SIZE = 1536;
    private final String feedId;
    private final AgentCoreEngineConfiguration.StorageAdapterConfiguration config;
    private final HttpClientBuilder httpClientBuilder;
    private final Diagnostics diagnostics;
    final long persistenceRefreshDelay;

    public AsyncInventoryStorage(String feedId, AgentCoreEngineConfiguration.StorageAdapterConfiguration config, int autoDiscoveryScanPeriodSeconds, HttpClientBuilder httpClientBuilder, Diagnostics diagnostics) {
        this.feedId = feedId;
        this.config = config;
        this.httpClientBuilder = httpClientBuilder;
        this.diagnostics = diagnostics;
        this.persistenceRefreshDelay = TimeUnit.DAYS.toMillis(7L) - TimeUnit.SECONDS.toMillis(autoDiscoveryScanPeriodSeconds) - 300000L;
    }

    public void shutdown() {
        log.debugf("Shutting down async inventory storage", new Object[0]);
    }

    private boolean needToRefresh(IDObject idObject) {
        return System.currentTimeMillis() > idObject.getPersistedTime() + this.persistenceRefreshDelay;
    }

    @Override
    public <L> void receivedEvent(InventoryEvent<L> event) {
        log.debug("Received inventory event");
        ResourceManager resourceManager = event.getResourceManager();
        MonitoredEndpoint<AgentCoreEngineConfiguration.EndpointConfiguration> endpoint = event.getSamplingService().getMonitoredEndpoint();
        String endpointTenantId = endpoint.getEndpointConfiguration().getTenantId();
        String tenantIdToUse = endpointTenantId != null ? endpointTenantId : this.config.getTenantId();
        Map<String, String> headers = this.getTenantHeader(tenantIdToUse);
        InventoryPayloadBuilder bldr = new InventoryPayloadBuilder(tenantIdToUse, this.feedId);
        long timestamp = System.currentTimeMillis();
        event.getResourceTypeManager().ifPresent(resourceTypeManager -> {
            List allResourceTypes = resourceTypeManager.getResourceTypesBreadthFirst();
            this.getMetricTypesToSync(allResourceTypes).forEach(mt -> {
                log.debugf("Updating metric type: %s", (Object)mt.getID().getIDString());
                this.performMetricTypeSync(bldr.buildMetricType(mt), tenantIdToUse);
                mt.setPersistedTime(timestamp);
            });
            allResourceTypes.stream().filter(this::needToRefresh).forEach(rt -> {
                log.debugf("Updating resource type: %s", (Object)rt.getID().getIDString());
                this.performResourceTypeSync(bldr.buildResourceType(rt), tenantIdToUse);
                rt.setPersistedTime(timestamp);
            });
        });
        Set addedOrModifiedIds = event.getAddedOrModifiedRootResources().stream().map(IDObject::getID).collect(Collectors.toSet());
        resourceManager.getRootResources().forEach(r -> {
            if (addedOrModifiedIds.contains(r.getID()) || this.needToRefresh((IDObject)r)) {
                log.debugf("Updating root resource: %s", (Object)r.getID().getIDString());
                this.performResourceSync(bldr.buildRootResource(resourceManager, r), tenantIdToUse, resourceManager.size((Resource)r));
                r.setPersistedTime(timestamp);
            }
        });
        event.getRemovedRootResources().forEach(r -> {
            log.debugf("Removing root resource: %s", (Object)r.getID().getIDString());
            InventoryMetric metric = InventoryMetric.resource(this.feedId, r.getID().getIDString(), null, null);
            this.deleteMetric(metric, headers);
        });
    }

    private <L> Collection<MeasurementType<L>> getMetricTypesToSync(List<ResourceType<L>> resourceTypes) {
        HashMap measTypes = new HashMap();
        resourceTypes.forEach(rt -> {
            rt.getMetricTypes().stream().filter(this::needToRefresh).forEach(mt -> {
                MeasurementType cfr_ignored_0 = measTypes.put(mt.getID().getIDString(), mt);
            });
            rt.getAvailTypes().stream().filter(this::needToRefresh).forEach(mt -> {
                MeasurementType cfr_ignored_0 = measTypes.put(mt.getID().getIDString(), mt);
            });
        });
        return measTypes.values();
    }

    private void deleteMetric(InventoryMetric metric, Map<String, String> headers) {
        try {
            StringBuilder url = Util.getContextUrlString(this.config.getUrl(), this.config.getMetricsContext()).append("strings/").append(metric.encodedName());
            Request request = this.httpClientBuilder.buildJsonDeleteRequest(url.toString(), headers);
            Call call = this.httpClientBuilder.getHttpClient().newCall(request);
            try (Response response = call.execute();){
                if (!response.isSuccessful()) {
                    throw new Exception("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.url().toString() + "]");
                }
            }
        }
        catch (InterruptedException ie) {
            log.errorFailedToStoreInventoryData(ie);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.errorFailedToStoreInventoryData(e);
            this.diagnostics.getStorageErrorRate().mark(1L);
        }
    }

    private void performResourceSync(InventoryStructure<Resource.Blueprint> resourceStructure, String tenantIdToUse, int totalResourceCount) {
        if (resourceStructure.getRoot() != null) {
            try {
                Map<String, Collection<String>> resourceTypes = AsyncInventoryStorage.extractResourceTypes(resourceStructure);
                Map<String, Collection<String>> metricTypes = AsyncInventoryStorage.extractMetricTypes(resourceStructure);
                InventoryMetric metric = InventoryMetric.resource(this.feedId, resourceStructure.getRoot().getId(), resourceTypes.keySet(), metricTypes.keySet());
                this.syncInventoryData(metric, new ExtendedInventoryStructure(resourceStructure, resourceTypes, metricTypes), tenantIdToUse, totalResourceCount);
            }
            catch (InterruptedException ie) {
                log.errorFailedToStoreInventoryData(ie);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.errorFailedToStoreInventoryData(e);
                this.diagnostics.getStorageErrorRate().mark(1L);
            }
        }
    }

    private static Map<String, Collection<String>> extractResourceTypes(InventoryStructure<Resource.Blueprint> resourceStructure) {
        HashMap<String, Collection<String>> resourcesPerType = new HashMap<String, Collection<String>>();
        AsyncInventoryStorage.extractResourceTypesForNode(resourceStructure, RelativePath.empty().get(), resourcesPerType);
        return resourcesPerType;
    }

    private static void extractResourceTypesForNode(InventoryStructure<Resource.Blueprint> resourceStructure, RelativePath nodePath, Map<String, Collection<String>> resourcesPerType) {
        Entity.Blueprint bp = resourceStructure.get(nodePath);
        if (bp instanceof Resource.Blueprint) {
            CanonicalPath resourceTypePath = CanonicalPath.fromString(((Resource.Blueprint)bp).getResourceTypePath());
            Collection idsForType = resourcesPerType.computeIfAbsent(resourceTypePath.getSegment().getElementId(), k -> new ArrayList());
            idsForType.add(nodePath.toString());
        }
        resourceStructure.getAllChildren(nodePath).forEach(child -> {
            SegmentType childSegmentType = Inventory.types().byBlueprint(child.getClass()).getSegmentType();
            RelativePath childPath = nodePath.modified().extend(childSegmentType, child.getId()).get();
            AsyncInventoryStorage.extractResourceTypesForNode(resourceStructure, childPath, resourcesPerType);
        });
    }

    private static Map<String, Collection<String>> extractMetricTypes(InventoryStructure<Resource.Blueprint> resourceStructure) {
        HashMap<String, Collection<String>> metricsPerType = new HashMap<String, Collection<String>>();
        AsyncInventoryStorage.extractMetricTypesForNode(resourceStructure, RelativePath.empty().get(), metricsPerType);
        return metricsPerType;
    }

    private static void extractMetricTypesForNode(InventoryStructure<Resource.Blueprint> resourceStructure, RelativePath nodePath, Map<String, Collection<String>> metricsPerType) {
        Entity.Blueprint bp = resourceStructure.get(nodePath);
        if (bp instanceof Metric.Blueprint) {
            CanonicalPath metricTypePath = CanonicalPath.fromString(((Metric.Blueprint)bp).getMetricTypePath());
            Collection idsForType = metricsPerType.computeIfAbsent(metricTypePath.getSegment().getElementId(), k -> new ArrayList());
            idsForType.add(nodePath.toString());
        }
        resourceStructure.getAllChildren(nodePath).forEach(child -> {
            SegmentType childSegmentType = Inventory.types().byBlueprint(child.getClass()).getSegmentType();
            RelativePath childPath = nodePath.modified().extend(childSegmentType, child.getId()).get();
            AsyncInventoryStorage.extractMetricTypesForNode(resourceStructure, childPath, metricsPerType);
        });
    }

    private void performResourceTypeSync(InventoryStructure.Offline<ResourceType.Blueprint> resourceTypeStructure, String tenantIdToUse) {
        if (resourceTypeStructure.getRoot() != null) {
            try {
                InventoryMetric metric = InventoryMetric.resourceType(this.feedId, resourceTypeStructure.getRoot().getId());
                this.syncInventoryData(metric, new ExtendedInventoryStructure(resourceTypeStructure), tenantIdToUse, 1);
            }
            catch (InterruptedException ie) {
                log.errorFailedToStoreInventoryData(ie);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.errorFailedToStoreInventoryData(e);
                this.diagnostics.getStorageErrorRate().mark(1L);
            }
        }
    }

    private void performMetricTypeSync(InventoryStructure.Offline<MetricType.Blueprint> metricTypeStructure, String tenantIdToUse) {
        if (metricTypeStructure.getRoot() != null) {
            try {
                InventoryMetric metric = InventoryMetric.metricType(this.feedId, metricTypeStructure.getRoot().getId());
                this.syncInventoryData(metric, new ExtendedInventoryStructure(metricTypeStructure), tenantIdToUse, 1);
            }
            catch (InterruptedException ie) {
                log.errorFailedToStoreInventoryData(ie);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.errorFailedToStoreInventoryData(e);
                this.diagnostics.getStorageErrorRate().mark(1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncInventoryData(InventoryMetric metric, ExtendedInventoryStructure inventoryStructure, String tenantId, int totalResourceCount) throws Exception {
        InventoryMetric.WithData metricChunks = this.compressAndChunk(metric, inventoryStructure);
        if (metricChunks.isEmpty()) {
            return;
        }
        Map<String, String> headers = this.getTenantHeader(tenantId);
        Timer.Context timer = this.diagnostics.getInventoryStorageRequestTimer().time();
        try {
            log.tracef("Syncing [%d] elements to inventory: headers=[%s] metric=[%s]", (Object)totalResourceCount, (Object)headers, (Object)metric.name());
            this.runSync(metricChunks, headers);
            this.tagMetric(metricChunks, headers);
            if (totalResourceCount > 0) {
                this.diagnostics.getInventoryRate().mark(totalResourceCount);
            }
        }
        finally {
            long durationNanos = timer.stop();
            if (log.isDebugEnabled()) {
                log.debugf("Took [%d]ms to sync [%d] elements to inventory", (Object)TimeUnit.MILLISECONDS.convert(durationNanos, TimeUnit.NANOSECONDS), (Object)totalResourceCount);
            }
        }
    }

    private void runSync(InventoryMetric.WithData metric, Map<String, String> headers) throws Exception {
        StringBuilder url = Util.getContextUrlString(this.config.getUrl(), this.config.getMetricsContext()).append("strings/").append(metric.encodedName()).append("/raw");
        Request request = this.httpClientBuilder.buildJsonPostRequest(url.toString(), headers, metric.getPayload());
        Call call = this.httpClientBuilder.getHttpClient().newCall(request);
        try (Response response = call.execute();){
            log.tracef("Received response while uploading chunks: code [%d]", (Object)response.code());
            if (!response.isSuccessful()) {
                throw new Exception("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.url().toString() + "]");
            }
        }
    }

    private void tagMetric(InventoryMetric.WithData metric, Map<String, String> headers) throws Exception {
        StringBuilder url = Util.getContextUrlString(this.config.getUrl(), this.config.getMetricsContext()).append("strings?overwrite=true");
        MetricDefinition def = metric.toMetricDefinition();
        Request request = this.httpClientBuilder.buildJsonPostRequest(url.toString(), headers, Util.toJson(def));
        Call call = this.httpClientBuilder.getHttpClient().newCall(request);
        try (Response response = call.execute();){
            log.tracef("Received response while committing chunks: code [%d]", (Object)response.code());
            if (!response.isSuccessful()) {
                throw new Exception("status-code=[" + response.code() + "], reason=[" + response.message() + "], url=[" + request.url().toString() + "]");
            }
        }
    }

    private InventoryMetric.WithData compressAndChunk(InventoryMetric metric, ExtendedInventoryStructure inventoryStructure) throws IOException {
        int size;
        String json = Util.toJson(inventoryStructure);
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(obj);
        gzip.write(json.getBytes("UTF-8"));
        gzip.close();
        byte[] compressed = obj.toByteArray();
        if (compressed.length <= 1536) {
            return metric.full(compressed);
        }
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        for (int pos = 0; pos < compressed.length; pos += size) {
            size = Math.min(1536, compressed.length - pos);
            byte[] chunk = new byte[size];
            System.arraycopy(compressed, pos, chunk, 0, size);
            chunks.add(chunk);
        }
        return metric.chunks(chunks, compressed.length);
    }

    private Map<String, String> getTenantHeader(String tenantId) {
        if (tenantId == null) {
            throw new IllegalArgumentException("tenantId must not be null");
        }
        return Collections.singletonMap("Hawkular-Tenant", tenantId);
    }

    private static class InventoryPayloadBuilder<L> {
        private final String feedId;
        private final String tenantId;

        InventoryPayloadBuilder(String tenantId, String feedId) {
            this.tenantId = tenantId;
            this.feedId = feedId;
        }

        InventoryStructure.Offline<Resource.Blueprint> buildRootResource(ResourceManager<L> resourceManager, Resource<L> root) {
            Resource.Blueprint rootBP = this.buildResourceBlueprint(root);
            InventoryStructure.Builder<Resource.Blueprint> invBldr = InventoryStructure.Offline.of(rootBP);
            this.resource(resourceManager, root, invBldr);
            return invBldr.build();
        }

        InventoryStructure.Offline<ResourceType.Blueprint> buildResourceType(ResourceType<L> resourceType) {
            InventoryStructure.Builder<ResourceType.Blueprint> invBldr = InventoryStructure.Offline.of(this.buildResourceTypeBlueprint(resourceType));
            this.resourceType(resourceType, invBldr);
            return invBldr.build();
        }

        InventoryStructure.Offline<MetricType.Blueprint> buildMetricType(MeasurementType<L> measurementType) {
            MetricType.Blueprint mtBP = this.buildMetricTypeBlueprint(measurementType);
            return InventoryStructure.Offline.of(mtBP).build();
        }

        private Resource.Blueprint buildResourceBlueprint(Resource<L> resource) {
            String resourceId = this.getInventoryId(resource);
            String resourceName = resource.getName().getNameString();
            String resourceTypePath = ((CanonicalPath)((CanonicalPath.ResourceTypeBuilder)this.newPathPrefix().resourceType(this.getInventoryId(resource.getResourceType()))).get()).toString();
            Map<String, Object> resourceProperties = resource.getProperties();
            Resource.Blueprint resourceBP = ((Resource.Blueprint.Builder)((Resource.Blueprint.Builder)((Resource.Blueprint.Builder)Resource.Blueprint.builder().withId(resourceId)).withName(resourceName)).withResourceTypePath(resourceTypePath).withProperties(resourceProperties)).build();
            return resourceBP;
        }

        private ResourceType.Blueprint buildResourceTypeBlueprint(ResourceType<L> resourceType) {
            String resourceTypeId = this.getInventoryId(resourceType);
            String resourceTypeName = resourceType.getName().getNameString();
            Map<String, Object> resourceTypeProperties = resourceType.getProperties();
            ResourceType.Blueprint resourceTypeBP = ((ResourceType.Blueprint.Builder)((ResourceType.Blueprint.Builder)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId(resourceTypeId)).withName(resourceTypeName)).withProperties(resourceTypeProperties)).build();
            return resourceTypeBP;
        }

        private MetricType.Blueprint buildMetricTypeBlueprint(MeasurementType<L> metricType) {
            MetricDataType metricDataType;
            String metricTypeId = this.getInventoryId(metricType);
            MetricUnit metricUnit = MetricUnit.NONE;
            if (metricType instanceof MetricType) {
                metricUnit = MetricUnit.valueOf(((MetricType)metricType).getMetricUnits().name());
                switch (((MetricType)metricType).getMetricType()) {
                    case GAUGE: {
                        metricDataType = MetricDataType.GAUGE;
                        break;
                    }
                    case COUNTER: {
                        metricDataType = MetricDataType.COUNTER;
                        break;
                    }
                    default: {
                        metricDataType = MetricDataType.GAUGE;
                        break;
                    }
                }
            } else if (metricType instanceof AvailType) {
                metricDataType = MetricDataType.AVAILABILITY;
            } else {
                throw new IllegalArgumentException("Invalid measurement type - please report this bug: " + metricType.getClass());
            }
            String metricTypeName = metricType.getName().getNameString();
            long metricTypeIntervalSecs = metricType.getInterval().seconds();
            Map<String, Object> metricTypeProperties = metricType.getProperties();
            return ((MetricType.Blueprint.Builder)((MetricType.Blueprint.Builder)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder(metricDataType).withId(metricTypeId)).withName(metricTypeName)).withInterval(metricTypeIntervalSecs).withProperties(metricTypeProperties)).withUnit(metricUnit).build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resource(ResourceManager<L> resourceManager, Resource<L> resource, InventoryStructure.AbstractBuilder<?> theBuilder) {
            Collection<ResourceConfigurationPropertyInstance<L>> resConfigInstances = resource.getResourceConfigurationProperties();
            this.resourceConfigurations(resConfigInstances, theBuilder);
            Collection<MeasurementInstance<L, MetricType<L>>> metricInstances = resource.getMetrics();
            for (Instance instance : metricInstances) {
                this.metric(instance, theBuilder);
            }
            Collection<MeasurementInstance<L, AvailType<L>>> availInstances = resource.getAvails();
            for (Instance instance : availInstances) {
                this.metric(instance, theBuilder);
            }
            Set<Resource<L>> set = resourceManager.getChildren(resource);
            for (Resource<L> child : set) {
                Resource.Blueprint childBP = this.buildResourceBlueprint(child);
                InventoryStructure.ChildBuilder<?> childBuilder = theBuilder.startChild(childBP);
                try {
                    this.resource(resourceManager, child, childBuilder);
                }
                finally {
                    childBuilder.end();
                }
            }
        }

        private void resourceType(ResourceType<L> resourceType, InventoryStructure.AbstractBuilder<?> theBuilder) {
            Collection<Operation<L>> ops = resourceType.getOperations();
            for (Operation<L> op : ops) {
                this.operation(op, theBuilder);
            }
            Collection<ResourceConfigurationPropertyType<L>> rcpts = resourceType.getResourceConfigurationPropertyTypes();
            this.resourceConfigurationTypes(rcpts, theBuilder);
        }

        private void metric(Instance<L, ?> metric, InventoryStructure.AbstractBuilder<?> theBuilder) {
            String metricId = this.getInventoryId(metric);
            String metricTypeId = this.getInventoryId((NamedObject)metric.getType());
            String metricTypePath = ((CanonicalPath)((CanonicalPath.MetricTypeBuilder)this.newPathPrefix().metricType(metricTypeId)).get()).toString();
            String metricName = metric.getName().getNameString();
            Map<String, Object> metricProperties = metric.getProperties();
            Metric.Blueprint blueprint = ((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId(metricId)).withMetricTypePath(metricTypePath).withName(metricName)).withProperties(metricProperties)).build();
            theBuilder.addChild(blueprint);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void operation(Operation<L> operation, InventoryStructure.AbstractBuilder<?> theBuilder) {
            String operationId = this.getInventoryId(operation);
            String operationName = operation.getName().getNameString();
            Map<String, Object> operationProperties = operation.getProperties();
            OperationType.Blueprint blueprint = ((OperationType.Blueprint.Builder)((OperationType.Blueprint.Builder)((OperationType.Blueprint.Builder)OperationType.Blueprint.builder().withId(operationId)).withName(operationName)).withProperties(operationProperties)).build();
            List<OperationParam> params = operation.getParameters();
            if (params.isEmpty()) {
                theBuilder.addChild(blueprint);
            } else {
                InventoryStructure.ChildBuilder<?> opBuilder = theBuilder.startChild(blueprint);
                try {
                    StructuredData.MapBuilder structDataBuilder = StructuredData.get().map();
                    for (OperationParam param : params) {
                        StructuredData.InnerMapBuilder innerMap = structDataBuilder.putMap(param.getName());
                        if (param.getType() != null) {
                            innerMap.putString("type", param.getType());
                        }
                        if (param.getDescription() != null) {
                            innerMap.putString("description", param.getDescription());
                        }
                        if (param.getDefaultValue() != null) {
                            innerMap.putString("defaultValue", param.getDefaultValue());
                        }
                        if (param.isRequired() != null) {
                            innerMap.putBool("required", param.isRequired());
                        }
                        innerMap.closeMap();
                    }
                    Object paramsDataEntity = DataEntity.Blueprint.builder().withRole(DataRole.OperationType.parameterTypes).withValue(structDataBuilder.build()).build();
                    opBuilder.addChild((Entity.Blueprint)paramsDataEntity);
                }
                finally {
                    opBuilder.end();
                }
            }
        }

        private void resourceConfigurationTypes(Collection<? extends ResourceConfigurationPropertyType<L>> rcpts, InventoryStructure.AbstractBuilder<?> theBuilder) {
            if (!rcpts.isEmpty()) {
                StructuredData.MapBuilder structDataBuilder = StructuredData.get().map();
                for (ResourceConfigurationPropertyType<L> rcpt : rcpts) {
                    structDataBuilder.putString(rcpt.getID().getIDString(), rcpt.getName().getNameString());
                }
                Object dataEntity = DataEntity.Blueprint.builder().withRole(DataRole.ResourceType.configurationSchema).withValue(structDataBuilder.build()).build();
                theBuilder.addChild((Entity.Blueprint)dataEntity);
            }
        }

        private void resourceConfigurations(Collection<? extends ResourceConfigurationPropertyInstance<L>> rcpis, InventoryStructure.AbstractBuilder<?> theBuilder) {
            if (!rcpis.isEmpty()) {
                StructuredData.MapBuilder structDataBuilder = StructuredData.get().map();
                for (ResourceConfigurationPropertyInstance<L> rcpi : rcpis) {
                    structDataBuilder.putString(rcpi.getID().getIDString(), rcpi.getValue());
                }
                Object dataEntity = DataEntity.Blueprint.builder().withRole(DataRole.Resource.configuration).withValue(structDataBuilder.build()).build();
                theBuilder.addChild((Entity.Blueprint)dataEntity);
            }
        }

        private String getInventoryId(NamedObject no) {
            String id = no.getID().equals(ID.NULL_ID) ? no.getName().getNameString() : no.getID().getIDString();
            return id;
        }

        private CanonicalPath.FeedBuilder newPathPrefix() {
            return (CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.tenantId)).feed(this.feedId);
        }
    }
}

