/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.agent.monitor.util;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.shaded.OkHttpClient;
import okhttp3.shaded.Request;
import okhttp3.shaded.ws.WebSocketCall;
import org.hawkular.agent.monitor.log.AgentLoggers;
import org.hawkular.agent.monitor.log.MsgLogger;
import org.hawkular.agent.monitor.util.Util;
import org.hawkular.agent.monitor.util.WildflyCompatibilityUtils;

public class BaseHttpClientGenerator {
    private static final MsgLogger log = AgentLoggers.getLogger(BaseHttpClientGenerator.class);
    private final Configuration configuration;
    private final OkHttpClient httpClient;

    public BaseHttpClientGenerator(Configuration configuration) {
        this.configuration = configuration;
        OkHttpClient.Builder httpClientBldr = new OkHttpClient.Builder();
        configuration.getConnectTimeoutSeconds().ifPresent(timeout -> httpClientBldr.connectTimeout(timeout.intValue(), TimeUnit.SECONDS));
        configuration.getReadTimeoutSeconds().ifPresent(timeout -> httpClientBldr.readTimeout(timeout.intValue(), TimeUnit.SECONDS));
        if (this.configuration.isUseSSL()) {
            SSLContext theSslContextToUse;
            X509TrustManager theTrustManagerToUse = null;
            if (this.configuration.getSslContext() == null) {
                if (this.configuration.getKeystorePath() != null) {
                    KeyStore keystore = this.loadKeystore(this.configuration.getKeystorePath(), this.configuration.getKeystorePassword());
                    TrustManager[] trustManagers = this.buildTrustManagers(keystore);
                    theSslContextToUse = this.buildSSLContext(keystore, this.configuration.getKeystorePassword(), trustManagers);
                    for (TrustManager tm : trustManagers) {
                        if (!(tm instanceof X509TrustManager)) continue;
                        theTrustManagerToUse = (X509TrustManager)tm;
                        break;
                    }
                } else {
                    theSslContextToUse = null;
                }
            } else {
                theSslContextToUse = this.configuration.getSslContext();
                theTrustManagerToUse = this.configuration.getX509TrustManager();
            }
            if (theSslContextToUse != null && theTrustManagerToUse != null) {
                httpClientBldr.sslSocketFactory(new WildflyCompatibilityUtils.EAP6WrappedSSLSocketFactory(theSslContextToUse.getSocketFactory()), theTrustManagerToUse);
            } else if (theSslContextToUse != null) {
                log.error("We have a SSLContext without a X509TrustManager.");
            }
        }
        this.httpClient = httpClientBldr.build();
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public WebSocketCall createWebSocketCall(String url, Map<String, String> headers) {
        String base64Credentials = this.buildBase64Credentials();
        Request.Builder requestBuilder = new Request.Builder().url(url).addHeader("Authorization", "Basic " + base64Credentials).addHeader("Accept", "application/json");
        if (headers != null) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        Request request = requestBuilder.build();
        WebSocketCall wsc = WebSocketCall.create(this.getHttpClient(), request);
        return wsc;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String buildBase64Credentials() {
        return Util.base64Encode(this.configuration.getUsername() + ":" + this.configuration.getPassword());
    }

    private KeyStore loadKeystore(String keystorePath, String keystorePassword) {
        try {
            return this.readKeyStore(keystorePath, keystorePassword);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot load keystore [%s]", keystorePath), e);
        }
    }

    private SSLContext buildSSLContext(KeyStore keyStore, String keystorePassword, TrustManager[] trustManagers) {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, keystorePassword.toCharArray());
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagers, new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot create SSL context from keystore", new Object[0]), e);
        }
    }

    private TrustManager[] buildTrustManagers(KeyStore keyStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot build TrustManager", e);
        }
    }

    private KeyStore readKeyStore(String keystorePath, String keystorePassword) throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = keystorePassword.toCharArray();
        File file = new File(keystorePath);
        log.infoUseKeystore(file.getAbsolutePath());
        try (FileInputStream fis = new FileInputStream(file);){
            ks.load(fis, password);
        }
        return ks;
    }

    public static class Configuration {
        private final String username;
        private final String password;
        private final boolean useSSL;
        private final String keystorePath;
        private final String keystorePassword;
        private final SSLContext sslContext;
        private final X509TrustManager x509TrustManager;
        private final Optional<Integer> connectTimeoutSeconds;
        private final Optional<Integer> readTimeoutSeconds;

        private Configuration(String username, String password, boolean useSSL, String keystorePath, String keystorePassword, SSLContext sslContext, X509TrustManager x509TrustManager, Optional<Integer> connectTimeoutSeconds, Optional<Integer> readTimeoutSeconds) {
            this.username = username;
            this.password = password;
            this.useSSL = useSSL;
            this.keystorePath = keystorePath;
            this.keystorePassword = keystorePassword;
            this.sslContext = sslContext;
            this.x509TrustManager = x509TrustManager;
            this.connectTimeoutSeconds = connectTimeoutSeconds;
            this.readTimeoutSeconds = readTimeoutSeconds;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public boolean isUseSSL() {
            return this.useSSL;
        }

        public String getKeystorePath() {
            return this.keystorePath;
        }

        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        public SSLContext getSslContext() {
            return this.sslContext;
        }

        public X509TrustManager getX509TrustManager() {
            return this.x509TrustManager;
        }

        public Optional<Integer> getConnectTimeoutSeconds() {
            return this.connectTimeoutSeconds;
        }

        public Optional<Integer> getReadTimeoutSeconds() {
            return this.readTimeoutSeconds;
        }

        public static class Builder {
            private String username;
            private String password;
            private boolean useSSL;
            private String keystorePath;
            private String keystorePassword;
            private SSLContext sslContext;
            private X509TrustManager x509TrustManager;
            private Optional<Integer> connectTimeoutSeconds = Optional.empty();
            private Optional<Integer> readTimeoutSeconds = Optional.empty();

            public Configuration build() {
                return new Configuration(this.username, this.password, this.useSSL, this.keystorePath, this.keystorePassword, this.sslContext, this.x509TrustManager, this.connectTimeoutSeconds, this.readTimeoutSeconds);
            }

            public Builder username(String s) {
                this.username = s;
                return this;
            }

            public Builder password(String s) {
                this.password = s;
                return this;
            }

            public Builder useSsl(boolean b) {
                this.useSSL = b;
                return this;
            }

            public Builder keystorePath(String s) {
                this.keystorePath = s;
                return this;
            }

            public Builder keystorePassword(String s) {
                this.keystorePassword = s;
                return this;
            }

            public Builder sslContext(SSLContext s) {
                this.sslContext = s;
                return this;
            }

            public Builder x509TrustManager(X509TrustManager x509TrustManager) {
                this.x509TrustManager = x509TrustManager;
                return this;
            }

            public Builder connectTimeout(int connectTimeoutSeconds) {
                this.connectTimeoutSeconds = Optional.of(connectTimeoutSeconds);
                return this;
            }

            public Builder readTimeout(int readTimeoutSeconds) {
                this.readTimeoutSeconds = Optional.of(readTimeoutSeconds);
                return this;
            }
        }
    }
}

