/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.common;

import com.shaded.fasterxml.jackson.core.JsonProcessingException;
import com.shaded.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSContext;

@ApplicationScoped
public class Bus {
    @Resource(name="java:/ConnectionFactory")
    private ConnectionFactory connectionFactory;
    private ObjectMapper mapper;

    @PostConstruct
    private void initMapper() {
        this.mapper = new ObjectMapper();
    }

    public void send(String s) {
    }

    public <T> void send(Destination destination, T value) {
        try (JMSContext context = this.connectionFactory.createContext();){
            String json = this.mapper.writeValueAsString(value);
            context.createProducer().send(destination, json);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

