/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.client.api;

import com.shaded.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.client.api.NotificationType;

@ApiModel(description="A general notification supplying the type and a map of properties.")
public class Notification {
    @JsonInclude
    NotificationType type;
    @JsonInclude
    Map<String, String> properties;

    public Notification() {
    }

    public Notification(NotificationType type, Map<String, String> properties) {
        this.type = type;
        this.properties = properties;
    }

    public NotificationType getType() {
        return this.type;
    }

    public void setType(NotificationType type) {
        this.type = type;
    }

    public void addProperty(String name, String value) {
        if (null == name || null == value) {
            throw new IllegalArgumentException("Property must have non-null name and value");
        }
        this.getProperties().put(name, value);
    }

    public Map<String, String> getProperties() {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Notification other = (Notification)obj;
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "Notification [type=" + (Object)((Object)this.type) + ", properties=" + this.properties + "]";
    }
}

