/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmrclient;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hawkular.dmrclient.Address;
import org.hawkular.dmrclient.FailureException;
import org.jboss.logging.Logger;
import org.shaded.jboss.as.controller.client.ModelControllerClient;
import org.shaded.jboss.as.controller.client.OperationMessageHandler;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;
import org.shaded.jboss.dmr.ValueExpression;

public class JBossASClient
implements AutoCloseable {
    protected final Logger log = Logger.getLogger(this.getClass());
    public static final String BATCH = "composite";
    public static final String BATCH_STEPS = "steps";
    public static final String OPERATION = "operation";
    public static final String ADDRESS = "address";
    public static final String RESULT = "result";
    public static final String OUTCOME = "outcome";
    public static final String OUTCOME_SUCCESS = "success";
    public static final String SUBSYSTEM = "subsystem";
    public static final String FAILURE_DESCRIPTION = "failure-description";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String READ_ATTRIBUTE = "read-attribute";
    public static final String READ_RESOURCE = "read-resource";
    public static final String WRITE_ATTRIBUTE = "write-attribute";
    public static final String ADD = "add";
    public static final String REMOVE = "remove";
    public static final String SYSTEM_PROPERTY = "system-property";
    public static final String PERSISTENT = "persistent";
    private final ModelControllerClient client;

    public JBossASClient(ModelControllerClient client) {
        this.client = client;
    }

    public static ModelNode createReadAttributeRequest(String attributeName, Address address) {
        return JBossASClient.createReadAttributeRequest(false, attributeName, address);
    }

    public static ModelNode createReadAttributeRequest(boolean runtime, String attributeName, Address address) {
        ModelNode op = JBossASClient.createRequest(READ_ATTRIBUTE, address);
        op.get("include-runtime").set(runtime);
        op.get(NAME).set(attributeName);
        return op;
    }

    public static ModelNode createWriteAttributeRequest(String attributeName, String attributeValue, Address address) {
        ModelNode op = JBossASClient.createRequest(WRITE_ATTRIBUTE, address);
        op.get(NAME).set(attributeName);
        JBossASClient.setPossibleExpression(op, VALUE, attributeValue);
        return op;
    }

    public static ModelNode createRequest(String operation, Address address) {
        return JBossASClient.createRequest(operation, address, null);
    }

    public static ModelNode createRequest(String operation, Address address, ModelNode extra) {
        ModelNode request = extra != null ? extra.clone() : new ModelNode();
        request.get(OPERATION).set(operation);
        request.get(ADDRESS).set(address.getAddressNode());
        return request;
    }

    public static ModelNode createBatchRequest(ModelNode ... steps) {
        ModelNode composite = new ModelNode();
        composite.get(OPERATION).set(BATCH);
        composite.get(ADDRESS).setEmptyList();
        ModelNode stepsNode = composite.get(BATCH_STEPS);
        for (ModelNode step : steps) {
            if (step == null) continue;
            stepsNode.add(step);
        }
        return composite;
    }

    public static List<String> getResultListAsStrings(ModelNode operationResult) {
        if (!operationResult.hasDefined(RESULT)) {
            return Collections.emptyList();
        }
        List<ModelNode> nodeList = operationResult.get(RESULT).asList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (ModelNode node : nodeList) {
            list.add(node.asString());
        }
        return list;
    }

    public static ModelNode getResults(ModelNode operationResult) {
        if (!operationResult.hasDefined(RESULT)) {
            return new ModelNode();
        }
        return operationResult.get(RESULT);
    }

    public static boolean isSuccess(ModelNode operationResult) {
        if (operationResult != null) {
            return operationResult.hasDefined(OUTCOME) && operationResult.get(OUTCOME).asString().equals(OUTCOME_SUCCESS);
        }
        return false;
    }

    public static String getFailureDescription(ModelNode operationResult) {
        ModelNode descr;
        if (JBossASClient.isSuccess(operationResult)) {
            return null;
        }
        if (operationResult != null && (descr = operationResult.get(FAILURE_DESCRIPTION)) != null) {
            return descr.asString();
        }
        return "Unknown failure";
    }

    public static ModelNode setPossibleExpression(ModelNode node, String name, String value) {
        if (value != null) {
            if (value.contains("${")) {
                return node.get(name).set(new ValueExpression(value));
            }
            return node.get(name).set(value);
        }
        return node.get(name).clear();
    }

    public ModelControllerClient getModelControllerClient() {
        return this.client;
    }

    @Override
    public void close() throws Exception {
        this.getModelControllerClient().close();
    }

    public ModelNode execute(ModelNode request) throws Exception {
        ModelControllerClient mcc = this.getModelControllerClient();
        return mcc.execute(request, OperationMessageHandler.logging);
    }

    public ModelNode readResource(Address addr) throws Exception {
        return this.readResource(addr, false);
    }

    public ModelNode readResource(Address addr, boolean recursive) throws Exception {
        ModelNode request = JBossASClient.createRequest(READ_RESOURCE, addr);
        request.get("recursive").set(recursive);
        ModelNode results = this.getModelControllerClient().execute(request, OperationMessageHandler.logging);
        if (JBossASClient.isSuccess(results)) {
            ModelNode resource = JBossASClient.getResults(results);
            return resource;
        }
        return null;
    }

    public void remove(Address doomedAddr) throws Exception {
        ModelNode request = JBossASClient.createRequest(REMOVE, doomedAddr);
        ModelNode response = this.execute(request);
        if (!JBossASClient.isSuccess(response)) {
            throw new FailureException(response, "Failed to remove resource at address [" + doomedAddr + "]");
        }
    }

    public ModelNode getAttribute(String attributeName, Address address) throws Exception {
        return this.getAttribute(false, attributeName, address);
    }

    public ModelNode getAttribute(boolean runtime, String attributeName, Address address) throws Exception {
        ModelNode op = JBossASClient.createReadAttributeRequest(runtime, attributeName, address);
        ModelNode results = this.execute(op);
        if (JBossASClient.isSuccess(results)) {
            return JBossASClient.getResults(results);
        }
        throw new FailureException(results, "Failed to get attribute [" + attributeName + "] from [" + address + "]");
    }

    public String getStringAttribute(String attributeName, Address address) throws Exception {
        return this.getStringAttribute(false, attributeName, address);
    }

    public String getStringAttribute(boolean runtime, String attributeName, Address address) throws Exception {
        return this.getAttribute(runtime, attributeName, address).asString();
    }

    public ModelNode findNodeInList(Address addr, String haystack, String needle) throws Exception {
        ModelNode queryNode = JBossASClient.createRequest(READ_RESOURCE, addr);
        ModelNode results = this.execute(queryNode);
        if (JBossASClient.isSuccess(results)) {
            ModelNode haystackNode = JBossASClient.getResults(results).get(haystack);
            if (haystackNode.getType() != ModelType.UNDEFINED) {
                List<ModelNode> haystackList = haystackNode.asList();
                for (ModelNode needleNode : haystackList) {
                    if (!needleNode.has(needle)) continue;
                    return needleNode;
                }
            }
            return null;
        }
        throw new FailureException(results, "Failed to get data for [" + addr + "]");
    }
}

