/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.dmrclient;

import java.util.List;
import org.hawkular.dmrclient.Address;
import org.hawkular.dmrclient.JBossASClient;
import org.shaded.jboss.as.controller.client.ModelControllerClient;
import org.shaded.jboss.dmr.ModelNode;

public class MessagingJBossASClient
extends JBossASClient {
    public static final String SUBSYSTEM_MESSAGING = "messaging";
    public static final String HORNETQ_SERVER = "hornetq-server";
    public static final String JMS_QUEUE = "jms-queue";

    public MessagingJBossASClient(ModelControllerClient client) {
        super(client);
    }

    public boolean isQueue(String queueName) throws Exception {
        String haystack;
        Address addr = Address.root().add("subsystem", SUBSYSTEM_MESSAGING, HORNETQ_SERVER, "default");
        return null != this.findNodeInList(addr, haystack = JMS_QUEUE, queueName);
    }

    public ModelNode createNewQueueRequest(String name, Boolean durable, List<String> entryNames) {
        String dmrTemplate = "{\"durable\" => \"%s\", \"entries\" => [\"%s\"] }";
        String dmr = String.format(dmrTemplate, null == durable ? "true" : durable.toString(), entryNames.get(0));
        Address addr = Address.root().add("subsystem", SUBSYSTEM_MESSAGING, HORNETQ_SERVER, "default", JMS_QUEUE, name);
        ModelNode request = ModelNode.fromString(dmr);
        request.get("operation").set("add");
        request.get("address").set(addr.getAddressNode());
        return request;
    }
}

