/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.EnumMap;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.MetadataPack;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.OperationType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.paths.SegmentType;

public interface Inventory {
    public static Types types() {
        return Types.INSTANCE;
    }

    public static final class ElementTypes<E extends AbstractElement, B extends Blueprint> {
        private final Class<B> blueprintType;
        private final Class<E> elementType;
        private final SegmentType segmentType;

        private ElementTypes(Class<B> blueprintType, Class<E> elementType, SegmentType segmentType) {
            this.blueprintType = blueprintType;
            this.elementType = elementType;
            this.segmentType = segmentType;
        }

        public Class<B> getBlueprintType() {
            return this.blueprintType;
        }

        public Class<E> getElementType() {
            return this.elementType;
        }

        public SegmentType getSegmentType() {
            return this.segmentType;
        }
    }

    public static final class Types {
        private static final Types INSTANCE = new Types();
        private static final EnumMap<SegmentType, ElementTypes<?, ?>> elementTypes = new EnumMap(SegmentType.class);

        private Types() {
        }

        public <B extends Blueprint> ElementTypes<? extends AbstractElement, B> byBlueprint(Class<B> blueprintType) {
            for (SegmentType st : SegmentType.values()) {
                ElementTypes<?, ?> ret = elementTypes.get((Object)st);
                if (!ret.getBlueprintType().equals(blueprintType)) continue;
                return ret;
            }
            throw new IllegalArgumentException("Unknown blueprint type: " + blueprintType);
        }

        public <E extends AbstractElement, B extends Blueprint> ElementTypes<E, B> byElement(Class<E> elementType) {
            for (SegmentType st : SegmentType.values()) {
                ElementTypes<?, ?> ret = elementTypes.get((Object)st);
                if (!ret.getElementType().equals(elementType)) continue;
                return ret;
            }
            throw new IllegalArgumentException("Unknown element type: " + elementType);
        }

        static {
            elementTypes.put(SegmentType.d, new ElementTypes(DataEntity.Blueprint.class, DataEntity.class, SegmentType.d));
            elementTypes.put(SegmentType.e, new ElementTypes(Environment.Blueprint.class, Environment.class, SegmentType.e));
            elementTypes.put(SegmentType.f, new ElementTypes(Feed.Blueprint.class, Feed.class, SegmentType.f));
            elementTypes.put(SegmentType.m, new ElementTypes(Metric.Blueprint.class, Metric.class, SegmentType.m));
            elementTypes.put(SegmentType.mp, new ElementTypes(MetadataPack.Blueprint.class, MetadataPack.class, SegmentType.mp));
            elementTypes.put(SegmentType.mt, new ElementTypes(MetricType.Blueprint.class, MetricType.class, SegmentType.mt));
            elementTypes.put(SegmentType.ot, new ElementTypes(OperationType.Blueprint.class, OperationType.class, SegmentType.ot));
            elementTypes.put(SegmentType.r, new ElementTypes(Resource.Blueprint.class, Resource.class, SegmentType.r));
            elementTypes.put(SegmentType.rl, new ElementTypes(Relationship.Blueprint.class, Relationship.class, SegmentType.rl));
            elementTypes.put(SegmentType.rt, new ElementTypes(ResourceType.Blueprint.class, ResourceType.class, SegmentType.rt));
            elementTypes.put(SegmentType.t, new ElementTypes(Tenant.Blueprint.class, Tenant.class, SegmentType.t));
        }
    }
}

