/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.json;

import com.shaded.fasterxml.jackson.core.JsonGenerator;
import com.shaded.fasterxml.jackson.databind.JsonSerializer;
import com.shaded.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.paths.RelativePath;

public final class InventoryStructureSerializer
extends JsonSerializer<InventoryStructure<?>> {
    @Override
    public void serialize(InventoryStructure<?> inventoryStructure, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        Object blueprint = inventoryStructure.getRoot();
        InventoryStructure.EntityType blueprintType = InventoryStructure.EntityType.ofBlueprint(blueprint.getClass());
        if (blueprintType == null) {
            throw new IllegalArgumentException("Unsupported type of root element: " + blueprint);
        }
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("type", blueprintType.name());
        jsonGenerator.writeObjectField("data", inventoryStructure.getRoot());
        jsonGenerator.writeFieldName("children");
        jsonGenerator.writeStartObject();
        this.serializeLevel(inventoryStructure, RelativePath.empty(), jsonGenerator);
        jsonGenerator.writeEndObject();
        jsonGenerator.writeEndObject();
    }

    private void serializeLevel(InventoryStructure<?> structure, RelativePath.Extender root, JsonGenerator gen) throws IOException {
        RelativePath rootPath = root.get();
        for (InventoryStructure.EntityType entityType : InventoryStructure.EntityType.values()) {
            List children = this.getChildren(structure, rootPath, entityType.elementType);
            if (children.isEmpty()) continue;
            gen.writeFieldName(entityType.name());
            gen.writeStartArray();
            for (Entity.Blueprint bl : children) {
                gen.writeStartObject();
                gen.writeObjectField("data", bl);
                gen.writeFieldName("children");
                gen.writeStartObject();
                this.serializeLevel(structure, rootPath.modified().extend(entityType.segmentType, bl.getId()), gen);
                gen.writeEndObject();
                gen.writeEndObject();
            }
            gen.writeEndArray();
        }
    }

    private <E extends Entity, B extends Entity.Blueprint> List<B> getChildren(InventoryStructure<?> structure, RelativePath path, Class<E> type) {
        try (Stream s = structure.getChildren(path, type);){
            List list = s.collect(Collectors.toList());
            return list;
        }
    }
}

