/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.http.client.fluent;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.shaded.apache.http.HttpHost;
import org.shaded.apache.http.auth.AuthScope;
import org.shaded.apache.http.auth.Credentials;
import org.shaded.apache.http.auth.MalformedChallengeException;
import org.shaded.apache.http.auth.NTCredentials;
import org.shaded.apache.http.auth.UsernamePasswordCredentials;
import org.shaded.apache.http.client.AuthCache;
import org.shaded.apache.http.client.ClientProtocolException;
import org.shaded.apache.http.client.CookieStore;
import org.shaded.apache.http.client.CredentialsProvider;
import org.shaded.apache.http.client.HttpClient;
import org.shaded.apache.http.client.fluent.InternalHttpRequest;
import org.shaded.apache.http.client.fluent.Request;
import org.shaded.apache.http.client.fluent.Response;
import org.shaded.apache.http.client.methods.HttpUriRequest;
import org.shaded.apache.http.client.protocol.HttpClientContext;
import org.shaded.apache.http.config.Registry;
import org.shaded.apache.http.config.RegistryBuilder;
import org.shaded.apache.http.conn.scheme.Scheme;
import org.shaded.apache.http.conn.socket.ConnectionSocketFactory;
import org.shaded.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.shaded.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.shaded.apache.http.conn.ssl.SSLInitializationException;
import org.shaded.apache.http.impl.auth.BasicScheme;
import org.shaded.apache.http.impl.client.BasicAuthCache;
import org.shaded.apache.http.impl.client.BasicCredentialsProvider;
import org.shaded.apache.http.impl.client.HttpClientBuilder;
import org.shaded.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.shaded.apache.http.message.BasicHeader;

public class Executor {
    static final PoolingHttpClientConnectionManager CONNMGR;
    static final HttpClient CLIENT;
    private final HttpClient httpclient;
    private final AuthCache authCache;
    private final CredentialsProvider credentialsProvider;
    private volatile CookieStore cookieStore;

    public static Executor newInstance() {
        return new Executor(CLIENT);
    }

    public static Executor newInstance(HttpClient httpclient) {
        return new Executor(httpclient != null ? httpclient : CLIENT);
    }

    Executor(HttpClient httpclient) {
        this.httpclient = httpclient;
        this.credentialsProvider = new BasicCredentialsProvider();
        this.authCache = new BasicAuthCache();
    }

    public Executor auth(AuthScope authScope, Credentials creds) {
        this.credentialsProvider.setCredentials(authScope, creds);
        return this;
    }

    public Executor auth(HttpHost host, Credentials creds) {
        AuthScope authScope = host != null ? new AuthScope(host.getHostName(), host.getPort()) : AuthScope.ANY;
        return this.auth(authScope, creds);
    }

    public Executor authPreemptive(HttpHost host) {
        BasicScheme basicScheme = new BasicScheme();
        try {
            basicScheme.processChallenge(new BasicHeader("WWW-Authenticate", "BASIC "));
        }
        catch (MalformedChallengeException malformedChallengeException) {
            // empty catch block
        }
        this.authCache.put(host, basicScheme);
        return this;
    }

    public Executor authPreemptiveProxy(HttpHost host) {
        BasicScheme basicScheme = new BasicScheme();
        try {
            basicScheme.processChallenge(new BasicHeader("Proxy-Authenticate", "BASIC "));
        }
        catch (MalformedChallengeException malformedChallengeException) {
            // empty catch block
        }
        this.authCache.put(host, basicScheme);
        return this;
    }

    public Executor auth(Credentials cred) {
        return this.auth(AuthScope.ANY, cred);
    }

    public Executor auth(String username, String password) {
        return this.auth(new UsernamePasswordCredentials(username, password));
    }

    public Executor auth(String username, String password, String workstation, String domain) {
        return this.auth(new NTCredentials(username, password, workstation, domain));
    }

    public Executor auth(HttpHost host, String username, String password) {
        return this.auth(host, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public Executor auth(HttpHost host, String username, String password, String workstation, String domain) {
        return this.auth(host, (Credentials)new NTCredentials(username, password, workstation, domain));
    }

    public Executor clearAuth() {
        this.credentialsProvider.clear();
        return this;
    }

    public Executor cookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public Executor clearCookies() {
        this.cookieStore.clear();
        return this;
    }

    public Response execute(Request request) throws ClientProtocolException, IOException {
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setAttribute("http.auth.credentials-provider", this.credentialsProvider);
        localContext.setAttribute("http.auth.auth-cache", this.authCache);
        localContext.setAttribute("http.cookie-store", this.cookieStore);
        InternalHttpRequest httprequest = request.prepareRequest();
        return new Response(this.httpclient.execute((HttpUriRequest)httprequest, localContext));
    }

    @Deprecated
    public static void registerScheme(Scheme scheme) {
    }

    @Deprecated
    public static void unregisterScheme(String name) {
    }

    static {
        SSLConnectionSocketFactory ssl = null;
        try {
            ssl = SSLConnectionSocketFactory.getSystemSocketFactory();
        }
        catch (SSLInitializationException ex) {
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, null, null);
                ssl = new SSLConnectionSocketFactory(sslcontext);
            }
            catch (SecurityException ignore) {
            }
            catch (KeyManagementException ignore) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        Registry<ConnectionSocketFactory> sfr = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)(ssl != null ? ssl : SSLConnectionSocketFactory.getSocketFactory()))).build();
        CONNMGR = new PoolingHttpClientConnectionManager(sfr);
        CONNMGR.setDefaultMaxPerRoute(100);
        CONNMGR.setMaxTotal(200);
        CLIENT = HttpClientBuilder.create().setConnectionManager(CONNMGR).build();
    }
}

