/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.http.osgi.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.shaded.apache.http.impl.client.CloseableHttpClient;
import org.shaded.apache.http.osgi.impl.OSGiClientBuilderFactory;
import org.shaded.apache.http.osgi.impl.OSGiProxyConfiguration;
import org.shaded.apache.http.osgi.services.HttpClientBuilderFactory;
import org.shaded.apache.http.osgi.services.ProxyConfiguration;

public final class HttpProxyConfigurationActivator
implements BundleActivator,
ManagedServiceFactory {
    private static final String SERVICE_FACTORY_NAME = "Apache HTTP Client Proxy Configuration Factory";
    private static final String SERVICE_PID = "org.shaded.apache.http.proxyconfigurator";
    private ServiceRegistration configurator;
    private ServiceRegistration clientFactory;
    private BundleContext context;
    private final Map<String, ServiceRegistration> registeredConfigurations = new LinkedHashMap<String, ServiceRegistration>();
    private final List<CloseableHttpClient> trackedHttpClients = new LinkedList<CloseableHttpClient>();

    public void start(BundleContext context) throws Exception {
        this.context = context;
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("service.pid", this.getName());
        props.put("service.vendor", context.getBundle().getHeaders("Bundle-Vendor"));
        props.put("service.description", SERVICE_FACTORY_NAME);
        this.configurator = context.registerService(ManagedServiceFactory.class.getName(), (Object)this, props);
        this.clientFactory = context.registerService(HttpClientBuilderFactory.class.getName(), (Object)new OSGiClientBuilderFactory(context, this.registeredConfigurations, this.trackedHttpClients), props);
    }

    public void stop(BundleContext context) throws Exception {
        for (ServiceRegistration registeredConfiguration : this.registeredConfigurations.values()) {
            registeredConfiguration.unregister();
        }
        if (this.configurator != null) {
            this.configurator.unregister();
        }
        if (this.clientFactory != null) {
            this.clientFactory.unregister();
        }
        for (CloseableHttpClient client : this.trackedHttpClients) {
            if (null == client) continue;
            HttpProxyConfigurationActivator.closeQuietly(client);
        }
        this.registeredConfigurations.clear();
        this.trackedHttpClients.clear();
    }

    public String getName() {
        return SERVICE_PID;
    }

    public void updated(String pid, Dictionary config) throws ConfigurationException {
        OSGiProxyConfiguration proxyConfiguration;
        ServiceRegistration registration = this.registeredConfigurations.get(pid);
        if (registration == null) {
            proxyConfiguration = new OSGiProxyConfiguration();
            ServiceRegistration configurationRegistration = this.context.registerService(ProxyConfiguration.class.getName(), (Object)proxyConfiguration, config);
            this.registeredConfigurations.put(pid, configurationRegistration);
        } else {
            proxyConfiguration = (OSGiProxyConfiguration)this.context.getService(registration.getReference());
        }
        Dictionary properties = config;
        proxyConfiguration.update(properties);
    }

    public void deleted(String pid) {
        ServiceRegistration registeredConfiguration = this.registeredConfigurations.get(pid);
        if (null != registeredConfiguration) {
            registeredConfiguration.unregister();
            this.registeredConfigurations.remove(pid);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

