/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.http.osgi.impl;

import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.shaded.apache.http.auth.AuthScope;
import org.shaded.apache.http.auth.Credentials;
import org.shaded.apache.http.auth.UsernamePasswordCredentials;
import org.shaded.apache.http.client.CredentialsProvider;
import org.shaded.apache.http.osgi.services.ProxyConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OSGiCredentialsProvider
implements CredentialsProvider {
    private final BundleContext bundleContext;
    private final Map<String, ServiceRegistration> registeredConfigurations;

    public OSGiCredentialsProvider(BundleContext bundleContext, Map<String, ServiceRegistration> registeredConfigurations) {
        this.bundleContext = bundleContext;
        this.registeredConfigurations = registeredConfigurations;
    }

    @Override
    public void setCredentials(AuthScope authscope, Credentials credentials) {
    }

    @Override
    public Credentials getCredentials(AuthScope authscope) {
        for (ServiceRegistration registration : this.registeredConfigurations.values()) {
            AuthScope actual;
            ProxyConfiguration proxyConfiguration;
            Object proxyConfigurationObject = this.bundleContext.getService(registration.getReference());
            if (proxyConfigurationObject == null || !(proxyConfiguration = (ProxyConfiguration)proxyConfigurationObject).isEnabled() || !authscope.equals(actual = new AuthScope(proxyConfiguration.getHostname(), proxyConfiguration.getPort()))) continue;
            return new UsernamePasswordCredentials(proxyConfiguration.getUsername(), proxyConfiguration.getPassword());
        }
        return null;
    }

    @Override
    public void clear() {
    }
}

