/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.apache.http.osgi.impl;

import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.shaded.apache.http.impl.client.CloseableHttpClient;
import org.shaded.apache.http.impl.client.HttpClientBuilder;
import org.shaded.apache.http.osgi.impl.OSGiCredentialsProvider;
import org.shaded.apache.http.osgi.impl.OSGiHttpRoutePlanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OSGiHttpClientBuilder
extends HttpClientBuilder {
    private final List<CloseableHttpClient> trackedHttpClients;

    public OSGiHttpClientBuilder(BundleContext bundleContext, Map<String, ServiceRegistration> registeredConfigurations, List<CloseableHttpClient> trackedHttpClients) {
        this.trackedHttpClients = trackedHttpClients;
        this.setDefaultCredentialsProvider(new OSGiCredentialsProvider(bundleContext, registeredConfigurations));
        this.setRoutePlanner(new OSGiHttpRoutePlanner(bundleContext, registeredConfigurations));
    }

    @Override
    public CloseableHttpClient build() {
        CloseableHttpClient httpClient = super.build();
        this.trackedHttpClients.add(httpClient);
        return httpClient;
    }
}

