/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.glassfish.json;

import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.shaded.json.JsonArray;
import javax.shaded.json.JsonArrayBuilder;
import javax.shaded.json.JsonException;
import javax.shaded.json.JsonObject;
import javax.shaded.json.JsonObjectBuilder;
import javax.shaded.json.JsonReader;
import javax.shaded.json.JsonStructure;
import javax.shaded.json.JsonValue;
import javax.shaded.json.stream.JsonParser;
import org.shaded.glassfish.json.JsonArrayBuilderImpl;
import org.shaded.glassfish.json.JsonMessages;
import org.shaded.glassfish.json.JsonObjectBuilderImpl;
import org.shaded.glassfish.json.JsonParserImpl;
import org.shaded.glassfish.json.api.BufferPool;

class JsonReaderImpl
implements JsonReader {
    private final JsonParserImpl parser;
    private boolean readDone;
    private final BufferPool bufferPool;

    JsonReaderImpl(Reader reader, BufferPool bufferPool) {
        this.parser = new JsonParserImpl(reader, bufferPool);
        this.bufferPool = bufferPool;
    }

    JsonReaderImpl(InputStream in, BufferPool bufferPool) {
        this.parser = new JsonParserImpl(in, bufferPool);
        this.bufferPool = bufferPool;
    }

    JsonReaderImpl(InputStream in, Charset charset, BufferPool bufferPool) {
        this.parser = new JsonParserImpl(in, charset, bufferPool);
        this.bufferPool = bufferPool;
    }

    @Override
    public JsonStructure read() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            JsonParser.Event e = this.parser.next();
            if (e == JsonParser.Event.START_ARRAY) {
                return this.readArray(new JsonArrayBuilderImpl(this.bufferPool));
            }
            if (e == JsonParser.Event.START_OBJECT) {
                return this.readObject(new JsonObjectBuilderImpl(this.bufferPool));
            }
        }
        throw new JsonException("Internal Error");
    }

    @Override
    public JsonObject readObject() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            JsonParser.Event e = this.parser.next();
            if (e == JsonParser.Event.START_OBJECT) {
                return this.readObject(new JsonObjectBuilderImpl(this.bufferPool));
            }
            if (e == JsonParser.Event.START_ARRAY) {
                throw new JsonException(JsonMessages.READER_EXPECTED_OBJECT_GOT_ARRAY());
            }
        }
        throw new JsonException("Internal Error");
    }

    @Override
    public JsonArray readArray() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            JsonParser.Event e = this.parser.next();
            if (e == JsonParser.Event.START_ARRAY) {
                return this.readArray(new JsonArrayBuilderImpl(this.bufferPool));
            }
            if (e == JsonParser.Event.START_OBJECT) {
                throw new JsonException(JsonMessages.READER_EXPECTED_ARRAY_GOT_OBJECT());
            }
        }
        throw new JsonException("Internal Error");
    }

    @Override
    public void close() {
        this.readDone = true;
        this.parser.close();
    }

    private JsonArray readArray(JsonArrayBuilder builder) {
        block10: while (this.parser.hasNext()) {
            JsonParser.Event e = this.parser.next();
            switch (e) {
                case START_ARRAY: {
                    JsonArray array = this.readArray(new JsonArrayBuilderImpl(this.bufferPool));
                    builder.add(array);
                    continue block10;
                }
                case START_OBJECT: {
                    JsonObject object = this.readObject(new JsonObjectBuilderImpl(this.bufferPool));
                    builder.add(object);
                    continue block10;
                }
                case VALUE_STRING: {
                    builder.add(this.parser.getString());
                    continue block10;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isDefinitelyInt()) {
                        builder.add(this.parser.getInt());
                        continue block10;
                    }
                    builder.add(this.parser.getBigDecimal());
                    continue block10;
                }
                case VALUE_TRUE: {
                    builder.add(JsonValue.TRUE);
                    continue block10;
                }
                case VALUE_FALSE: {
                    builder.add(JsonValue.FALSE);
                    continue block10;
                }
                case VALUE_NULL: {
                    builder.addNull();
                    continue block10;
                }
                case END_ARRAY: {
                    return builder.build();
                }
            }
            throw new JsonException("Internal Error");
        }
        throw new JsonException("Internal Error");
    }

    private JsonObject readObject(JsonObjectBuilder builder) {
        String key = null;
        block11: while (this.parser.hasNext()) {
            JsonParser.Event e = this.parser.next();
            switch (e) {
                case START_ARRAY: {
                    JsonArray array = this.readArray(new JsonArrayBuilderImpl(this.bufferPool));
                    builder.add(key, array);
                    continue block11;
                }
                case START_OBJECT: {
                    JsonObject object = this.readObject(new JsonObjectBuilderImpl(this.bufferPool));
                    builder.add(key, object);
                    continue block11;
                }
                case KEY_NAME: {
                    key = this.parser.getString();
                    continue block11;
                }
                case VALUE_STRING: {
                    builder.add(key, this.parser.getString());
                    continue block11;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isDefinitelyInt()) {
                        builder.add(key, this.parser.getInt());
                        continue block11;
                    }
                    builder.add(key, this.parser.getBigDecimal());
                    continue block11;
                }
                case VALUE_TRUE: {
                    builder.add(key, JsonValue.TRUE);
                    continue block11;
                }
                case VALUE_FALSE: {
                    builder.add(key, JsonValue.FALSE);
                    continue block11;
                }
                case VALUE_NULL: {
                    builder.addNull(key);
                    continue block11;
                }
                case END_OBJECT: {
                    return builder.build();
                }
            }
            throw new JsonException("Internal Error");
        }
        throw new JsonException("Internal Error");
    }
}

