/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.glassfish.json;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import javax.shaded.json.JsonArray;
import javax.shaded.json.JsonObject;
import javax.shaded.json.JsonStructure;
import javax.shaded.json.JsonValue;
import javax.shaded.json.JsonWriter;
import org.shaded.glassfish.json.JsonGeneratorImpl;
import org.shaded.glassfish.json.JsonMessages;
import org.shaded.glassfish.json.JsonPrettyGeneratorImpl;
import org.shaded.glassfish.json.api.BufferPool;

class JsonWriterImpl
implements JsonWriter {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final JsonGeneratorImpl generator;
    private boolean writeDone;
    private final NoFlushOutputStream os;

    JsonWriterImpl(Writer writer, BufferPool bufferPool) {
        this(writer, false, bufferPool);
    }

    JsonWriterImpl(Writer writer, boolean prettyPrinting, BufferPool bufferPool) {
        this.generator = prettyPrinting ? new JsonPrettyGeneratorImpl(writer, bufferPool) : new JsonGeneratorImpl(writer, bufferPool);
        this.os = null;
    }

    JsonWriterImpl(OutputStream out, BufferPool bufferPool) {
        this(out, UTF_8, false, bufferPool);
    }

    JsonWriterImpl(OutputStream out, boolean prettyPrinting, BufferPool bufferPool) {
        this(out, UTF_8, prettyPrinting, bufferPool);
    }

    JsonWriterImpl(OutputStream out, Charset charset, boolean prettyPrinting, BufferPool bufferPool) {
        this.os = new NoFlushOutputStream(out);
        this.generator = prettyPrinting ? new JsonPrettyGeneratorImpl(this.os, charset, bufferPool) : new JsonGeneratorImpl(this.os, charset, bufferPool);
    }

    @Override
    public void writeArray(JsonArray array) {
        if (this.writeDone) {
            throw new IllegalStateException(JsonMessages.WRITER_WRITE_ALREADY_CALLED());
        }
        this.writeDone = true;
        this.generator.writeStartArray();
        for (JsonValue value : array) {
            this.generator.write(value);
        }
        this.generator.writeEnd();
        this.generator.flushBuffer();
        if (this.os != null) {
            this.generator.flush();
        }
    }

    @Override
    public void writeObject(JsonObject object) {
        if (this.writeDone) {
            throw new IllegalStateException(JsonMessages.WRITER_WRITE_ALREADY_CALLED());
        }
        this.writeDone = true;
        this.generator.writeStartObject();
        for (Map.Entry e : object.entrySet()) {
            this.generator.write((String)e.getKey(), (JsonValue)e.getValue());
        }
        this.generator.writeEnd();
        this.generator.flushBuffer();
        if (this.os != null) {
            this.generator.flush();
        }
    }

    @Override
    public void write(JsonStructure value) {
        if (value instanceof JsonArray) {
            this.writeArray((JsonArray)value);
        } else {
            this.writeObject((JsonObject)value);
        }
    }

    @Override
    public void close() {
        this.writeDone = true;
        this.generator.close();
    }

    private static final class NoFlushOutputStream
    extends FilterOutputStream {
        public NoFlushOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() {
        }
    }
}

