/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller;

import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.registry.Resource;
import org.shaded.jboss.dmr.ModelNode;

public abstract class AbstractModelUpdateHandler
implements OperationStepHandler {
    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        this.updateModel(operation, resource);
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    AbstractModelUpdateHandler.this.performRuntime(context, operation, resource);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            AbstractModelUpdateHandler.this.rollbackRuntime(context, operation, resource);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    protected void updateModel(ModelNode operation, Resource resource) throws OperationFailedException {
        this.updateModel(operation, resource.getModel());
    }

    protected abstract void updateModel(ModelNode var1, ModelNode var2) throws OperationFailedException;

    protected boolean requiresRuntime(OperationContext context) {
        return context.isNormalServer();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
    }
}

