/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller;

import java.util.HashSet;
import java.util.Set;
import org.shaded.jboss.as.controller.BlockingTimeout;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.ProxyController;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.wildfly.security.manager.WildFlySecurityManager;

class BlockingTimeoutImpl
implements BlockingTimeout {
    private static final int DEFAULT_TIMEOUT = 300;
    private static final String DEFAULT_TIMEOUT_STRING = Long.toString(300L);
    private static final int SHORT_TIMEOUT = 5000;
    private static final int DEFAULT_DOMAIN_TIMEOUT_ADDER = 5000;
    private static final String DEFAULT_DOMAIN_TIMEOUT_STRING = Long.toString(5000L);
    public static final String DOMAIN_TEST_SYSTEM_PROPERTY = "org.shaded.wildfly.unsupported.test.domain-timeout-adder";
    private static String sysPropLocalValue;
    private static int defaultLocalValue;
    private static String sysPropDomainValue;
    private static int defaultDomainValue;
    private final int blockingTimeout;
    private final int shortTimeout;
    private final int domainTimeoutAdder;
    private volatile boolean localTimeoutDetected;
    private Set<PathAddress> domainTimeouts;

    BlockingTimeoutImpl(ModelNode headerValue) {
        if (headerValue != null && headerValue.isDefined()) {
            Integer opHeaderValue = headerValue.asInt();
            if (opHeaderValue < 1) {
                throw ControllerLogger.MGMT_OP_LOGGER.invalidBlockingTimeout(opHeaderValue.longValue(), "blocking-timeout");
            }
            this.blockingTimeout = opHeaderValue * 1000;
        } else {
            this.blockingTimeout = BlockingTimeoutImpl.resolveDefaultTimeout();
        }
        this.shortTimeout = Math.min(this.blockingTimeout, 5000);
        this.domainTimeoutAdder = BlockingTimeoutImpl.resolveDomainTimeoutAdder();
    }

    private static int resolveDefaultTimeout() {
        String propValue = WildFlySecurityManager.getPropertyPrivileged("jboss.as.management.blocking.timeout", DEFAULT_TIMEOUT_STRING);
        if (sysPropLocalValue == null || !sysPropLocalValue.equals(propValue)) {
            sysPropLocalValue = propValue;
            int number = -1;
            try {
                number = Integer.valueOf(sysPropLocalValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (number > 0) {
                defaultLocalValue = number * 1000;
            } else {
                ControllerLogger.MGMT_OP_LOGGER.invalidDefaultBlockingTimeout(sysPropLocalValue, "jboss.as.management.blocking.timeout", 300L);
                defaultLocalValue = 300000;
            }
        }
        return defaultLocalValue;
    }

    private static int resolveDomainTimeoutAdder() {
        String propValue = WildFlySecurityManager.getPropertyPrivileged(DOMAIN_TEST_SYSTEM_PROPERTY, DEFAULT_DOMAIN_TIMEOUT_STRING);
        if (sysPropDomainValue == null || !sysPropDomainValue.equals(propValue)) {
            sysPropDomainValue = propValue;
            int number = -1;
            try {
                number = Integer.valueOf(sysPropDomainValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (number > 0) {
                defaultDomainValue = number;
            } else {
                ControllerLogger.MGMT_OP_LOGGER.invalidDefaultBlockingTimeout(sysPropDomainValue, DOMAIN_TEST_SYSTEM_PROPERTY, 5000L);
                defaultDomainValue = 5000;
            }
        }
        return defaultDomainValue;
    }

    @Override
    public final int getLocalBlockingTimeout() {
        return this.localTimeoutDetected ? this.shortTimeout : this.blockingTimeout;
    }

    @Override
    public final int getProxyBlockingTimeout(PathAddress targetAddress, ProxyController proxyController) {
        PathAddress processAddress = BlockingTimeoutImpl.getProcessAddress(targetAddress);
        int multiple = proxyController.getProxyNodeAddress().size() < processAddress.size() ? 2 : 1;
        return this.getProcessBaseTimeout(processAddress) + multiple * this.domainTimeoutAdder;
    }

    @Override
    public int getDomainBlockingTimeout(boolean multipleProxies) {
        int delayMultiple = multipleProxies ? 2 : 1;
        return this.blockingTimeout + delayMultiple * this.domainTimeoutAdder;
    }

    @Override
    public final void timeoutDetected() {
        this.localTimeoutDetected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proxyTimeoutDetected(PathAddress targetAddress) {
        PathAddress processAddress = BlockingTimeoutImpl.getProcessAddress(targetAddress);
        BlockingTimeoutImpl blockingTimeoutImpl = this;
        synchronized (blockingTimeoutImpl) {
            if (this.domainTimeouts == null) {
                this.domainTimeouts = new HashSet<PathAddress>();
            }
            this.domainTimeouts.add(processAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getProcessBaseTimeout(PathAddress processAddress) {
        BlockingTimeoutImpl blockingTimeoutImpl = this;
        synchronized (blockingTimeoutImpl) {
            return this.domainTimeouts != null && this.domainTimeouts.contains(processAddress) ? this.shortTimeout : this.blockingTimeout;
        }
    }

    private static PathAddress getProcessAddress(PathAddress targetAddress) {
        if (targetAddress.size() < 2) {
            return targetAddress;
        }
        if ("server".equals(targetAddress.getElement(1).getKey())) {
            return targetAddress.subAddress(0, 2);
        }
        return targetAddress.subAddress(0, 1);
    }
}

