/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.shaded.jboss.as.controller.AbstractOperationContext;
import org.shaded.jboss.as.controller.BootErrorCollector;
import org.shaded.jboss.as.controller.CapabilityRegistry;
import org.shaded.jboss.as.controller.ContainerStateMonitor;
import org.shaded.jboss.as.controller.ControlledProcessState;
import org.shaded.jboss.as.controller.CurrentOperationIdHolder;
import org.shaded.jboss.as.controller.ExpressionResolver;
import org.shaded.jboss.as.controller.HostServerGroupTracker;
import org.shaded.jboss.as.controller.ManagementModel;
import org.shaded.jboss.as.controller.ModelController;
import org.shaded.jboss.as.controller.ModelControllerLock;
import org.shaded.jboss.as.controller.OperationContext;
import org.shaded.jboss.as.controller.OperationContextImpl;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.OperationStepHandler;
import org.shaded.jboss.as.controller.ParallelBootOperationStepHandler;
import org.shaded.jboss.as.controller.ParsedBootOp;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.PathElement;
import org.shaded.jboss.as.controller.ProcessType;
import org.shaded.jboss.as.controller.ReadOnlyContext;
import org.shaded.jboss.as.controller.RunningMode;
import org.shaded.jboss.as.controller.RunningModeControl;
import org.shaded.jboss.as.controller.SecurityActions;
import org.shaded.jboss.as.controller.access.Authorizer;
import org.shaded.jboss.as.controller.audit.AuditLogger;
import org.shaded.jboss.as.controller.audit.ManagedAuditLogger;
import org.shaded.jboss.as.controller.capability.registry.RuntimeCapabilityRegistry;
import org.shaded.jboss.as.controller.client.ModelControllerClient;
import org.shaded.jboss.as.controller.client.Operation;
import org.shaded.jboss.as.controller.client.OperationAttachments;
import org.shaded.jboss.as.controller.client.OperationMessageHandler;
import org.shaded.jboss.as.controller.client.OperationResponse;
import org.shaded.jboss.as.controller.extension.ExtensionAddHandler;
import org.shaded.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.shaded.jboss.as.controller.extension.ParallelExtensionAddHandler;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.notification.NotificationSupport;
import org.shaded.jboss.as.controller.operations.common.Util;
import org.shaded.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.shaded.jboss.as.controller.persistence.ConfigurationPersister;
import org.shaded.jboss.as.controller.registry.DelegatingResource;
import org.shaded.jboss.as.controller.registry.ManagementResourceRegistration;
import org.shaded.jboss.as.controller.registry.NotificationHandlerRegistration;
import org.shaded.jboss.as.controller.registry.OperationEntry;
import org.shaded.jboss.as.controller.registry.PlaceholderResource;
import org.shaded.jboss.as.controller.registry.Resource;
import org.shaded.jboss.as.core.security.AccessMechanism;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.msc.service.ServiceListener;
import org.shaded.jboss.msc.service.ServiceRegistry;
import org.shaded.jboss.msc.service.ServiceTarget;
import org.shaded.jboss.threads.AsyncFuture;
import org.shaded.jboss.threads.AsyncFutureTask;
import org.shaded.wildfly.security.manager.action.GetAccessControlContextAction;

class ModelControllerImpl
implements ModelController {
    private static final String INITIAL_BOOT_OPERATION = "initial-boot-operation";
    private static final String POST_EXTENSION_BOOT_OPERATION = "post-extension-boot-operation";
    static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();
    private final ServiceRegistry serviceRegistry;
    private final ServiceTarget serviceTarget;
    private final ModelControllerLock controllerLock = new ModelControllerLock();
    private final ContainerStateMonitor stateMonitor;
    private final AtomicReference<ManagementModelImpl> managementModel = new AtomicReference();
    private final ConfigurationPersister persister;
    private final ProcessType processType;
    private final RunningModeControl runningModeControl;
    private final AtomicBoolean bootingFlag = new AtomicBoolean(true);
    private final OperationStepHandler prepareStep;
    private final ControlledProcessState processState;
    private final ExecutorService executorService;
    private final ExpressionResolver expressionResolver;
    private final Authorizer authorizer;
    private final ConcurrentMap<Integer, OperationContextImpl> activeOperations = new ConcurrentHashMap<Integer, OperationContextImpl>();
    private final Random random = new Random();
    private final ManagedAuditLogger auditLogger;
    private final BootErrorCollector bootErrorCollector;
    private final NotificationSupport notificationSupport;
    private final HostServerGroupTracker hostServerGroupTracker;
    private final Resource.ResourceEntry modelControllerResource;
    private final OperationStepHandler extraValidationStepHandler;

    ModelControllerImpl(ServiceRegistry serviceRegistry, ServiceTarget serviceTarget, ManagementResourceRegistration rootRegistration, ContainerStateMonitor stateMonitor, ConfigurationPersister persister, ProcessType processType, RunningModeControl runningModeControl, OperationStepHandler prepareStep, ControlledProcessState processState, ExecutorService executorService, ExpressionResolver expressionResolver, Authorizer authorizer, ManagedAuditLogger auditLogger, NotificationSupport notificationSupport, BootErrorCollector bootErrorCollector, OperationStepHandler extraValidationStepHandler, CapabilityRegistry capabilityRegistry) {
        assert (serviceRegistry != null);
        this.serviceRegistry = serviceRegistry;
        assert (serviceTarget != null);
        this.serviceTarget = serviceTarget;
        assert (rootRegistration != null);
        assert (capabilityRegistry != null);
        ManagementModelImpl mmi = new ManagementModelImpl(rootRegistration, Resource.Factory.create(), capabilityRegistry);
        mmi.publish();
        assert (stateMonitor != null);
        this.stateMonitor = stateMonitor;
        assert (persister != null);
        this.persister = persister;
        assert (processType != null);
        this.processType = processType;
        assert (runningModeControl != null);
        this.runningModeControl = runningModeControl;
        assert (notificationSupport != null);
        this.notificationSupport = notificationSupport;
        OperationStepHandler operationStepHandler = this.prepareStep = prepareStep == null ? new DefaultPrepareStepHandler() : prepareStep;
        assert (processState != null);
        this.processState = processState;
        this.serviceTarget.addListener((ServiceListener<Object>)stateMonitor);
        this.executorService = executorService;
        assert (expressionResolver != null);
        this.expressionResolver = expressionResolver;
        assert (authorizer != null);
        this.authorizer = authorizer;
        assert (auditLogger != null);
        this.auditLogger = auditLogger;
        assert (bootErrorCollector != null);
        this.bootErrorCollector = bootErrorCollector;
        this.hostServerGroupTracker = processType.isManagedDomain() ? new HostServerGroupTracker() : null;
        this.modelControllerResource = new ModelControllerResource();
        this.extraValidationStepHandler = extraValidationStepHandler;
        auditLogger.startBoot();
    }

    @Override
    public ModelNode execute(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationAttachments attachments) {
        OperationResponse or = this.internalExecute(operation, handler, control, attachments, this.prepareStep, false, false);
        ModelNode result = or.getResponseNode();
        try {
            or.close();
        }
        catch (IOException e) {
            ControllerLogger.ROOT_LOGGER.debugf((Throwable)e, "Caught exception closing response to %s whose associated streams, if any, were not wanted", (Object)operation);
        }
        return result;
    }

    @Override
    public OperationResponse execute(Operation operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control) {
        return this.internalExecute(operation.getOperation(), handler, control, operation, this.prepareStep, false, false);
    }

    private AbstractOperationContext getDelegateContext(int operationId) {
        AbstractOperationContext delegateContext;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        if ((delegateContext = (AbstractOperationContext)this.activeOperations.get(operationId)) == null) {
            throw ControllerLogger.ROOT_LOGGER.noContextToDelegateTo(operationId);
        }
        return delegateContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelNode executeReadOnlyOperation(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep, int operationId) {
        AbstractOperationContext delegateContext = this.getDelegateContext(operationId);
        CurrentOperationIdHolder.setCurrentOperationID(operationId);
        try {
            ModelNode modelNode = this.executeReadOnlyOperation(operation, delegateContext.getManagementModel(), control, prepareStep, delegateContext);
            return modelNode;
        }
        finally {
            CurrentOperationIdHolder.setCurrentOperationID(null);
        }
    }

    protected ModelNode executeReadOnlyOperation(ModelNode operation, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep) {
        AbstractOperationContext delegateContext = this.getDelegateContext(CurrentOperationIdHolder.getCurrentOperationID());
        return this.executeReadOnlyOperation(operation, delegateContext.getManagementModel(), control, prepareStep, delegateContext);
    }

    protected ModelNode executeReadOnlyOperation(ModelNode operation, Resource resource, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep) {
        int operationId = CurrentOperationIdHolder.getCurrentOperationID();
        AbstractOperationContext delegateContext = this.getDelegateContext(operationId);
        ManagementModelImpl current = delegateContext.getManagementModel();
        ManagementModelImpl mgmtModel = new ManagementModelImpl(current.getRootResourceRegistration(), resource, current.capabilityRegistry);
        return this.executeReadOnlyOperation(operation, mgmtModel, control, prepareStep, delegateContext);
    }

    protected ModelNode executeReadOnlyOperation(ModelNode operation, ManagementModelImpl model, final ModelController.OperationTransactionControl control, OperationStepHandler prepareStep, AbstractOperationContext delegateContext) {
        final ModelNode response = new ModelNode();
        int operationId = CurrentOperationIdHolder.getCurrentOperationID();
        ModelController.OperationTransactionControl txControl = control == null ? null : new ModelController.OperationTransactionControl(){

            @Override
            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                control.operationPrepared(transaction, response);
            }
        };
        ReadOnlyContext context = new ReadOnlyContext(this.processType, this.runningModeControl.getRunningMode(), txControl, this.processState, false, model, delegateContext, this, operationId);
        context.addStep(response, operation, prepareStep, OperationContext.Stage.MODEL);
        context.executeOperation();
        if (!response.hasDefined("response-headers") || !response.get("response-headers").hasDefined("process-state")) {
            ControlledProcessState.State state = this.processState.getState();
            switch (state) {
                case RELOAD_REQUIRED: 
                case RESTART_REQUIRED: {
                    response.get("response-headers", "process-state").set(state.toString());
                    break;
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected OperationResponse internalExecute(ModelNode operation, OperationMessageHandler handler, final ModelController.OperationTransactionControl control, OperationAttachments attachments, OperationStepHandler prepareStep, boolean attemptLock, boolean partialModel) {
        block28: {
            block26: {
                block27: {
                    sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkPermission(ModelController.ACCESS_PERMISSION);
                    }
                    headers = operation.has("operation-headers") != false ? operation.get("operation-headers") : null;
                    rollbackOnFailure = headers == null || headers.hasDefined("rollback-on-runtime-failure") == false || headers.get("rollback-on-runtime-failure").asBoolean() != false;
                    contextFlags = rollbackOnFailure != false ? EnumSet.of(AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL) : EnumSet.noneOf(AbstractOperationContext.ContextFlag.class);
                    v0 = restartResourceServices = headers != null && headers.hasDefined("allow-resource-service-restart") != false && headers.get("allow-resource-service-restart").asBoolean() != false;
                    if (restartResourceServices) {
                        contextFlags.add(AbstractOperationContext.ContextFlag.ALLOW_RESOURCE_SERVICE_RESTART);
                    }
                    blockingTimeoutConfig = headers != null && headers.hasDefined("blocking-timeout") != false ? headers.get("blocking-timeout") : null;
                    responseNode = Util.validateOperation(operation);
                    if (responseNode.hasDefined("failure-description")) {
                        return OperationResponse.Factory.createSimple(responseNode);
                    }
                    originalResultTxControl = control == null ? null : new ModelController.OperationTransactionControl(){

                        @Override
                        public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                            control.operationPrepared(transaction, responseNode);
                        }
                    };
                    accessMechanism = null;
                    accessContext = SecurityActions.currentAccessAuditContext();
                    if (accessContext != null) {
                        if (operation.hasDefined("operation-headers")) {
                            operationHeaders = operation.get("operation-headers");
                            if (operationHeaders.hasDefined("domain-uuid")) {
                                accessContext.setDomainUuid(operationHeaders.get("domain-uuid").asString());
                            }
                            if (operationHeaders.hasDefined("access-mechanism")) {
                                accessContext.setAccessMechanism(AccessMechanism.valueOf(operationHeaders.get("access-mechanism").asString()));
                            }
                        }
                        accessMechanism = accessContext.getAccessMechanism();
                    }
                    if (accessMechanism != null && this.bootingFlag.get()) {
                        return ModelControllerImpl.handleExternalRequestDuringBoot();
                    }
                    do {
                        responseStreams = null;
                    } while (this.activeOperations.putIfAbsent(operationID = Integer.valueOf(this.random.nextInt()), context = new OperationContextImpl(operationID, operation.get("operation").asString(), operation.get("address"), this, this.processType, this.runningModeControl.getRunningMode(), contextFlags, handler, attachments, this.managementModel.get(), originalResultTxControl, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, blockingTimeoutConfig, accessMechanism, this.notificationSupport, false, this.extraValidationStepHandler, partialModel)) != null);
                    CurrentOperationIdHolder.setCurrentOperationID(operationID);
                    shouldUnlock = false;
                    try {
                        if (!attemptLock) ** GOTO lbl72
                        if (this.controllerLock.detectDeadlockAndGetLock(operationID)) break block26;
                        responseNode.get("outcome").set("failed");
                        responseNode.get("failure-description").set(ControllerLogger.ROOT_LOGGER.cannotGetControllerLock());
                        var22_22 = OperationResponse.Factory.createSimple(responseNode);
                        if (responseNode.hasDefined("response-headers") && responseNode.get("response-headers").hasDefined("process-state")) break block27;
                        state = this.processState.getState();
                    }
                    catch (Throwable var24_25) {
                        if (!responseNode.hasDefined("response-headers") || !responseNode.get("response-headers").hasDefined("process-state")) {
                            state = this.processState.getState();
                            switch (5.$SwitchMap$org$jboss$as$controller$ControlledProcessState$State[state.ordinal()]) {
                                case 1: 
                                case 2: {
                                    responseNode.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                                    break;
                                }
                            }
                        }
                        if (shouldUnlock) {
                            this.controllerLock.unlock(operationID);
                        }
                        this.activeOperations.remove(operationID);
                        CurrentOperationIdHolder.setCurrentOperationID(null);
                        throw var24_25;
                    }
                    switch (5.$SwitchMap$org$jboss$as$controller$ControlledProcessState$State[state.ordinal()]) {
                        case 1: 
                        case 2: {
                            responseNode.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                            break;
                        }
                    }
                }
                if (shouldUnlock) {
                    this.controllerLock.unlock(operationID);
                }
                this.activeOperations.remove(operationID);
                CurrentOperationIdHolder.setCurrentOperationID(null);
                return var22_22;
            }
            shouldUnlock = true;
lbl72:
            // 2 sources

            context.addStep(responseNode, operation, prepareStep, OperationContext.Stage.MODEL);
            ControllerLogger.MGMT_OP_LOGGER.tracef("Executing %s", (Object)operation);
            context.executeOperation();
            responseStreams = context.getResponseStreams();
            if (responseNode.hasDefined("response-headers") && responseNode.get("response-headers").hasDefined("process-state")) break block28;
            state = this.processState.getState();
            switch (5.$SwitchMap$org$jboss$as$controller$ControlledProcessState$State[state.ordinal()]) {
                case 1: 
                case 2: {
                    responseNode.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                    break;
                }
            }
        }
        if (shouldUnlock) {
            this.controllerLock.unlock(operationID);
        }
        this.activeOperations.remove(operationID);
        CurrentOperationIdHolder.setCurrentOperationID(null);
        if (responseStreams == null || responseStreams.size() == 0) {
            return OperationResponse.Factory.createSimple(responseNode);
        }
        return new OperationResponseImpl(responseNode, responseStreams);
    }

    private static OperationResponse handleExternalRequestDuringBoot() {
        ModelNode result = new ModelNode();
        result.get("outcome").set("failed");
        result.get("failure-description").set(ControllerLogger.MGMT_OP_LOGGER.managementUnavailableDuringBoot());
        return OperationResponse.Factory.createSimple(result);
    }

    boolean boot(List<ModelNode> bootList, OperationMessageHandler handler, ModelController.OperationTransactionControl control, boolean rollbackOnRuntimeFailure, MutableRootResourceRegistrationProvider parallelBootRootResourceRegistrationProvider, boolean skipModelValidation, boolean partialModel) {
        OperationContext.ResultAction resultAction;
        Integer operationID = this.random.nextInt();
        EnumSet<AbstractOperationContext.ContextFlag> contextFlags = rollbackOnRuntimeFailure ? EnumSet.of(AbstractOperationContext.ContextFlag.ROLLBACK_ON_FAIL) : EnumSet.noneOf(AbstractOperationContext.ContextFlag.class);
        OperationContextImpl context = new OperationContextImpl(operationID, INITIAL_BOOT_OPERATION, EMPTY_ADDRESS, this, this.processType, this.runningModeControl.getRunningMode(), contextFlags, handler, null, this.managementModel.get(), control, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, null, null, this.notificationSupport, true, this.extraValidationStepHandler, true);
        BootOperations bootOperations = this.organizeBootOperations(bootList, operationID, parallelBootRootResourceRegistrationProvider);
        OperationContext.ResultAction resultAction2 = resultAction = bootOperations.invalid ? OperationContext.ResultAction.ROLLBACK : OperationContext.ResultAction.KEEP;
        if (bootOperations.initialOps.size() > 0) {
            for (Object initialOp : bootOperations.initialOps) {
                context.addBootStep((ParsedBootOp)initialOp);
            }
            resultAction = ((AbstractOperationContext)context).executeOperation();
        }
        if (resultAction == OperationContext.ResultAction.KEEP && bootOperations.postExtensionOps != null) {
            OperationContextImpl postExtContext = new OperationContextImpl(operationID, POST_EXTENSION_BOOT_OPERATION, EMPTY_ADDRESS, this, this.processType, this.runningModeControl.getRunningMode(), contextFlags, handler, null, this.managementModel.get(), control, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, null, null, this.notificationSupport, true, this.extraValidationStepHandler, partialModel);
            for (ParsedBootOp parsedOp : bootOperations.postExtensionOps) {
                if (parsedOp.handler == null) {
                    parsedOp = new ParsedBootOp(parsedOp, this.managementModel.get().getRootResourceRegistration().getOperationHandler(parsedOp.address, parsedOp.operationName));
                }
                if (parsedOp.handler == null) {
                    this.logNoHandler(parsedOp);
                    postExtContext.setRollbackOnly();
                    break;
                }
                postExtContext.addBootStep(parsedOp);
            }
            resultAction = ((AbstractOperationContext)postExtContext).executeOperation();
            if (!skipModelValidation && resultAction == OperationContext.ResultAction.KEEP && bootOperations.postExtensionOps != null) {
                HashSet<PathAddress> validateAddresses = new HashSet<PathAddress>();
                Resource root = this.managementModel.get().getRootResource();
                this.addAllAddresses(PathAddress.EMPTY_ADDRESS, root, validateAddresses);
                OperationContextImpl validateContext = new OperationContextImpl(operationID, POST_EXTENSION_BOOT_OPERATION, EMPTY_ADDRESS, this, this.processType, this.runningModeControl.getRunningMode(), contextFlags, handler, null, this.managementModel.get(), control, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, null, null, this.notificationSupport, false, this.extraValidationStepHandler, partialModel);
                validateContext.addModifiedResourcesForModelValidation(validateAddresses);
                resultAction = ((AbstractOperationContext)validateContext).executeOperation();
            }
        }
        return resultAction == OperationContext.ResultAction.KEEP;
    }

    private void addAllAddresses(PathAddress current, Resource resource, Set<PathAddress> addresses) {
        addresses.add(current);
        for (String name : resource.getChildTypes()) {
            for (Resource.ResourceEntry entry : resource.getChildren(name)) {
                if (entry.isProxy() || entry.isRuntime()) continue;
                this.addAllAddresses(current.append(entry.getPathElement()), entry, addresses);
            }
        }
    }

    private BootOperations organizeBootOperations(List<ModelNode> bootList, int lockPermit, MutableRootResourceRegistrationProvider parallelBootRootResourceRegistrationProvider) {
        ArrayList<ParsedBootOp> initialOps = new ArrayList<ParsedBootOp>();
        ArrayList<ParsedBootOp> postExtensionOps = null;
        boolean invalid = false;
        boolean sawExtensionAdd = false;
        ManagementResourceRegistration rootRegistration = this.managementModel.get().getRootResourceRegistration();
        MutableRootResourceRegistrationProvider parallellBRRRProvider = parallelBootRootResourceRegistrationProvider != null ? parallelBootRootResourceRegistrationProvider : ModelControllerImpl.getMutableRootResourceRegistrationProvider();
        ParallelExtensionAddHandler parallelExtensionAddHandler = this.executorService == null ? null : new ParallelExtensionAddHandler(this.executorService, parallellBRRRProvider);
        ParallelBootOperationStepHandler parallelSubsystemHandler = this.executorService != null && this.processType.isServer() && this.runningModeControl.getRunningMode() == RunningMode.NORMAL ? new ParallelBootOperationStepHandler(this.executorService, rootRegistration, this.processState, this, lockPermit, this.extraValidationStepHandler) : null;
        boolean registeredParallelSubsystemHandler = false;
        int subsystemIndex = 0;
        for (ModelNode bootOp : bootList) {
            OperationStepHandler stepHandler;
            ParsedBootOp parsedOp = new ParsedBootOp(bootOp);
            if (postExtensionOps != null) {
                if (parsedOp.isExtensionAdd()) {
                    stepHandler = (ExtensionAddHandler)rootRegistration.getOperationHandler(parsedOp.address, parsedOp.operationName);
                    if (parallelExtensionAddHandler != null) {
                        parallelExtensionAddHandler.addParsedOp(parsedOp, (ExtensionAddHandler)stepHandler);
                        continue;
                    }
                    initialOps.add(new ParsedBootOp(parsedOp, stepHandler));
                    continue;
                }
                if (parallelSubsystemHandler == null || !parallelSubsystemHandler.addSubsystemOperation(parsedOp)) {
                    if (registeredParallelSubsystemHandler && (parsedOp.isInterfaceOperation() || parsedOp.isSocketOperation())) {
                        postExtensionOps.add(subsystemIndex++, parsedOp);
                        continue;
                    }
                    postExtensionOps.add(parsedOp);
                    continue;
                }
                if (registeredParallelSubsystemHandler) continue;
                postExtensionOps.add(parallelSubsystemHandler.getParsedBootOp());
                subsystemIndex = postExtensionOps.size() - 1;
                registeredParallelSubsystemHandler = true;
                continue;
            }
            stepHandler = rootRegistration.getOperationHandler(parsedOp.address, parsedOp.operationName);
            if (!sawExtensionAdd && stepHandler == null) {
                this.logNoHandler(parsedOp);
                invalid = true;
                break;
            }
            if (stepHandler instanceof ExtensionAddHandler) {
                if (parallelExtensionAddHandler != null) {
                    parallelExtensionAddHandler.addParsedOp(parsedOp, (ExtensionAddHandler)stepHandler);
                    if (!sawExtensionAdd) {
                        initialOps.add(parallelExtensionAddHandler.getParsedBootOp());
                    }
                } else {
                    initialOps.add(new ParsedBootOp(parsedOp, stepHandler));
                }
                sawExtensionAdd = true;
                continue;
            }
            if (!sawExtensionAdd) {
                initialOps.add(new ParsedBootOp(parsedOp, stepHandler));
                continue;
            }
            postExtensionOps = new ArrayList<ParsedBootOp>(32);
            if (parallelSubsystemHandler == null || !parallelSubsystemHandler.addSubsystemOperation(parsedOp)) {
                postExtensionOps.add(parsedOp);
                continue;
            }
            postExtensionOps.add(parallelSubsystemHandler.getParsedBootOp());
            registeredParallelSubsystemHandler = true;
        }
        return new BootOperations(initialOps, postExtensionOps, invalid);
    }

    void finishBoot() {
        this.auditLogger.bootDone();
        this.bootingFlag.set(false);
    }

    ManagementModel getManagementModel() {
        return this.managementModel.get();
    }

    Resource.ResourceEntry getModelControllerResource() {
        return this.modelControllerResource;
    }

    @Override
    public ModelControllerClient createClient(final Executor executor) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        return new ModelControllerClient(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public ModelNode execute(ModelNode operation) throws IOException {
                return this.execute(operation, null);
            }

            @Override
            public ModelNode execute(Operation operation) throws IOException {
                return this.execute(operation, null);
            }

            @Override
            public ModelNode execute(ModelNode operation, OperationMessageHandler messageHandler) {
                return ModelControllerImpl.this.execute(operation, messageHandler, ModelController.OperationTransactionControl.COMMIT, null);
            }

            @Override
            public ModelNode execute(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                return ModelControllerImpl.this.execute(operation.getOperation(), messageHandler, ModelController.OperationTransactionControl.COMMIT, operation);
            }

            @Override
            public OperationResponse executeOperation(Operation operation, OperationMessageHandler messageHandler) throws IOException {
                return ModelControllerImpl.this.execute(operation, messageHandler, ModelController.OperationTransactionControl.COMMIT);
            }

            @Override
            public AsyncFuture<ModelNode> executeAsync(ModelNode operation, OperationMessageHandler messageHandler) {
                return this.executeAsync(operation, messageHandler, null, ResponseConverter.TO_MODEL_NODE);
            }

            @Override
            public AsyncFuture<ModelNode> executeAsync(Operation operation, OperationMessageHandler messageHandler) {
                return this.executeAsync(operation.getOperation(), messageHandler, operation, ResponseConverter.TO_MODEL_NODE);
            }

            @Override
            public AsyncFuture<OperationResponse> executeOperationAsync(Operation operation, OperationMessageHandler messageHandler) {
                return this.executeAsync(operation.getOperation(), messageHandler, operation, ResponseConverter.TO_OPERATION_RESPONSE);
            }

            private <T> AsyncFuture<T> executeAsync(final ModelNode operation, final OperationMessageHandler messageHandler, final OperationAttachments attachments, ResponseConverter<T> responseConverter) {
                if (executor == null) {
                    throw ControllerLogger.ROOT_LOGGER.nullAsynchronousExecutor();
                }
                final AtomicReference opThread = new AtomicReference();
                class OpTask<T>
                extends AsyncFutureTask<T> {
                    private final ResponseConverter<T> responseConverter;

                    OpTask(ResponseConverter<T> responseConverter) {
                        super(this$1.executor);
                        this.responseConverter = responseConverter;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void asyncCancel(boolean interruptionDesired) {
                        Thread thread = opThread.getAndSet(Thread.currentThread());
                        if (thread == null) {
                            this.setCancelled();
                        } else {
                            thread.interrupt();
                            boolean interrupted = false;
                            AtomicReference atomicReference = opThread;
                            synchronized (atomicReference) {
                                while (opThread.get() != null) {
                                    try {
                                        opThread.wait();
                                    }
                                    catch (InterruptedException ie) {
                                        interrupted = true;
                                    }
                                }
                            }
                            this.setCancelled();
                            if (interrupted) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    }

                    void handleResult(OperationResponse result) {
                        ModelNode responseNode;
                        ModelNode modelNode = responseNode = result == null ? null : result.getResponseNode();
                        if (responseNode != null && responseNode.hasDefined("outcome") && "cancelled".equals(responseNode.get("outcome").asString())) {
                            this.setCancelled();
                        } else {
                            this.setResult(this.responseConverter.fromOperationResponse(result));
                        }
                    }
                }
                final OpTask opTask = new OpTask(responseConverter);
                final AccessControlContext acc = AccessController.doPrivileged(GetAccessControlContextAction.getInstance());
                executor.execute(new Runnable(){
                    {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (opThread.compareAndSet(null, Thread.currentThread())) {
                                OperationResponse response = AccessController.doPrivileged(new PrivilegedAction<OperationResponse>(){

                                    @Override
                                    public OperationResponse run() {
                                        Operation op = attachments == null ? Operation.Factory.create(operation) : Operation.Factory.create(operation, attachments.getInputStreams(), attachments.isAutoCloseStreams());
                                        return ModelControllerImpl.this.execute(op, messageHandler, ModelController.OperationTransactionControl.COMMIT);
                                    }
                                }, acc);
                                opTask.handleResult(response);
                            }
                        }
                        finally {
                            AtomicReference atomicReference = opThread;
                            synchronized (atomicReference) {
                                opThread.set(null);
                                opThread.notifyAll();
                            }
                        }
                    }
                });
                return opTask;
            }
        };
    }

    ConfigurationPersister.PersistenceResource writeModel(final ManagementModelImpl model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        ControllerLogger.MGMT_OP_LOGGER.tracef("persisting %s from %s", (Object)model.rootResource, (Object)model);
        ModelNode newModel = Resource.Tools.readModel(model.rootResource);
        final ConfigurationPersister.PersistenceResource delegate = this.persister.store(newModel, affectedAddresses);
        return new ConfigurationPersister.PersistenceResource(){

            @Override
            public void commit() {
                if (ModelControllerImpl.this.hostServerGroupTracker != null) {
                    ModelControllerImpl.this.hostServerGroupTracker.invalidate();
                }
                model.publish();
                delegate.commit();
            }

            @Override
            public void rollback() {
                model.discard();
                delegate.rollback();
            }
        };
    }

    void publishCapabilityRegistry(ManagementModelImpl model) {
        if (model.capabilityRegistry.isModified()) {
            model.capabilityRegistry.publish();
        }
    }

    void discardModel(ManagementModelImpl model) {
        model.discard();
    }

    void acquireLock(Integer permit, boolean interruptibly) throws InterruptedException {
        if (interruptibly) {
            this.controllerLock.lockInterruptibly(permit);
        } else {
            this.controllerLock.lock(permit);
        }
    }

    boolean acquireLock(Integer permit, boolean interruptibly, long timeout) throws InterruptedException {
        if (interruptibly) {
            return this.controllerLock.lockInterruptibly(permit, timeout, TimeUnit.SECONDS);
        }
        return this.controllerLock.lock(permit, timeout, TimeUnit.SECONDS);
    }

    void releaseLock(Integer permit) {
        this.controllerLock.unlock(permit);
    }

    void logContainerStateChangesAndReset() {
        this.stateMonitor.logContainerStateChangesAndReset();
    }

    void awaitContainerStability(long timeout, TimeUnit timeUnit, boolean interruptibly) throws InterruptedException, TimeoutException {
        if (interruptibly) {
            this.stateMonitor.awaitStability(timeout, timeUnit);
        } else {
            this.stateMonitor.awaitStabilityUninterruptibly(timeout, timeUnit);
        }
    }

    ContainerStateMonitor.ContainerStateChangeReport awaitContainerStateChangeReport(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        return this.stateMonitor.awaitContainerStateChangeReport(timeout, timeUnit);
    }

    ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    @Override
    public NotificationHandlerRegistration getNotificationRegistry() {
        return this.notificationSupport.getNotificationRegistry();
    }

    NotificationSupport getNotificationSupport() {
        return this.notificationSupport;
    }

    ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.expressionResolver.resolveExpressions(node);
    }

    Authorizer getAuthorizer() {
        return this.authorizer;
    }

    private void logNoHandler(ParsedBootOp parsedOp) {
        ManagementResourceRegistration child = this.managementModel.get().getRootResourceRegistration().getSubModel(parsedOp.address);
        if (child == null) {
            ControllerLogger.ROOT_LOGGER.error(ControllerLogger.ROOT_LOGGER.noSuchResourceType(parsedOp.address));
        } else {
            ControllerLogger.ROOT_LOGGER.error(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(parsedOp.operationName, parsedOp.address));
        }
    }

    AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    static MutableRootResourceRegistrationProvider getMutableRootResourceRegistrationProvider() {
        return MutableRootResourceRegistrationProviderImpl.INSTANCE;
    }

    void addFailureDescription(ModelNode operation, ModelNode failure) {
        if (this.bootingFlag.get()) {
            this.bootErrorCollector.addFailureDescription(operation, failure);
        }
    }

    private OperationStepHandler resolveOperationHandler(PathAddress address, String operationName) {
        PathElement pe;
        ManagementResourceRegistration rootRegistration = this.managementModel.get().getRootResourceRegistration();
        OperationStepHandler result = rootRegistration.getOperationHandler(address, operationName);
        if (result == null && address.size() > 0 && (pe = address.getLastElement()).isWildcard()) {
            String type = pe.getKey();
            PathAddress parent = address.subAddress(0, address.size() - 1);
            Set<PathElement> children = rootRegistration.getChildAddresses(parent);
            if (children != null) {
                OperationStepHandler found = null;
                for (PathElement child : children) {
                    OperationStepHandler osh;
                    if (!type.equals(child.getKey())) continue;
                    OperationEntry oe = rootRegistration.getOperationEntry(parent.append(child), operationName);
                    OperationStepHandler operationStepHandler = osh = oe == null ? null : oe.getOperationHandler();
                    if (osh == null || found != null && !found.equals(osh)) {
                        found = null;
                        break;
                    }
                    found = osh;
                }
                if (found != null) {
                    result = found;
                }
            }
        }
        return result;
    }

    static {
        EMPTY_ADDRESS.protect();
    }

    private static interface ResponseConverter<T> {
        public static final ResponseConverter<ModelNode> TO_MODEL_NODE = new ResponseConverter<ModelNode>(){

            @Override
            public ModelNode fromOperationResponse(OperationResponse or) {
                ModelNode result = or.getResponseNode();
                try {
                    or.close();
                }
                catch (IOException e) {
                    ControllerLogger.ROOT_LOGGER.debugf((Throwable)e, "Caught exception closing %s whose associated streams, if any, were not wanted", (Object)or);
                }
                return result;
            }
        };
        public static final ResponseConverter<OperationResponse> TO_OPERATION_RESPONSE = new ResponseConverter<OperationResponse>(){

            @Override
            public OperationResponse fromOperationResponse(OperationResponse or) {
                return or;
            }
        };

        public T fromOperationResponse(OperationResponse var1);
    }

    private static class OperationResponseImpl
    implements OperationResponse {
        private final ModelNode simpleResponse;
        private final Map<String, OperationResponse.StreamEntry> inputStreams;

        private OperationResponseImpl(ModelNode simpleResponse, Map<String, OperationResponse.StreamEntry> inputStreams) {
            this.simpleResponse = simpleResponse;
            this.inputStreams = inputStreams;
            ModelNode header = simpleResponse.get("response-headers", "attached-streams");
            header.setEmptyList();
            for (OperationResponse.StreamEntry entry : inputStreams.values()) {
                ModelNode streamNode = new ModelNode();
                streamNode.get("uuid").set(entry.getUUID());
                streamNode.get("mime-type").set(entry.getMimeType());
                header.add(streamNode);
            }
        }

        @Override
        public ModelNode getResponseNode() {
            return this.simpleResponse;
        }

        @Override
        public List<OperationResponse.StreamEntry> getInputStreams() {
            return new ArrayList<OperationResponse.StreamEntry>(this.inputStreams.values());
        }

        @Override
        public OperationResponse.StreamEntry getInputStream(String uuid) {
            return this.inputStreams.get(uuid);
        }

        @Override
        public void close() throws IOException {
            int i = 0;
            for (OperationResponse.StreamEntry is : this.inputStreams.values()) {
                try {
                    is.getStream().close();
                }
                catch (Exception e) {
                    ControllerLogger.MGMT_OP_LOGGER.debugf((Throwable)e, "Failed closing response stream at index %d", i);
                }
                ++i;
            }
        }
    }

    final class ManagementModelImpl
    implements ManagementModel {
        private final ManagementResourceRegistration resourceRegistration;
        private final Resource rootResource;
        private final ManagementResourceRegistration delegatingResourceRegistration;
        private final Resource delegatingResource;
        private final CapabilityRegistry capabilityRegistry;
        private volatile boolean published;

        ManagementModelImpl(ManagementResourceRegistration resourceRegistration, final Resource rootResource, CapabilityRegistry capabilityRegistry) {
            this.resourceRegistration = resourceRegistration;
            this.rootResource = rootResource;
            assert (capabilityRegistry != null);
            this.capabilityRegistry = capabilityRegistry;
            this.delegatingResourceRegistration = resourceRegistration;
            this.delegatingResource = new DelegatingResource(new DelegatingResource.ResourceDelegateProvider(){

                @Override
                public Resource getDelegateResource() {
                    Resource result = ManagementModelImpl.this.published ? ((ManagementModelImpl)ModelControllerImpl.this.managementModel.get()).rootResource : rootResource;
                    return result;
                }
            });
        }

        @Override
        public ManagementResourceRegistration getRootResourceRegistration() {
            return this.delegatingResourceRegistration;
        }

        @Override
        public Resource getRootResource() {
            return this.delegatingResource;
        }

        @Override
        public RuntimeCapabilityRegistry getCapabilityRegistry() {
            return this.capabilityRegistry;
        }

        ManagementModelImpl cloneRootResource() {
            CapabilityRegistry currentCaps;
            Resource currentResource;
            ManagementResourceRegistration mrr;
            if (this.published) {
                ManagementModelImpl currentPublished = (ManagementModelImpl)ModelControllerImpl.this.managementModel.get();
                mrr = currentPublished.resourceRegistration;
                currentResource = currentPublished.rootResource;
                currentCaps = currentPublished.capabilityRegistry;
            } else {
                mrr = this.resourceRegistration;
                currentResource = this.rootResource;
                currentCaps = this.capabilityRegistry;
            }
            Resource clone = currentResource.clone();
            ManagementModelImpl result = new ManagementModelImpl(mrr, clone, currentCaps);
            ControllerLogger.MGMT_OP_LOGGER.tracef("cloned to %s to create %s and %s", (Object)currentResource, (Object)clone, (Object)result);
            return result;
        }

        CapabilityRegistry.CapabilityValidation validateCapabilityRegistry(boolean forceCheck, boolean hostXmlOnly) {
            if (!this.published || this.capabilityRegistry.isModified() || forceCheck) {
                return this.capabilityRegistry.resolveCapabilities(this.getRootResource(), hostXmlOnly);
            }
            return CapabilityRegistry.CapabilityValidation.OK;
        }

        private void publish() {
            ModelControllerImpl.this.managementModel.set(this);
            this.published = true;
            ControllerLogger.MGMT_OP_LOGGER.tracef("published %s", (Object)this);
        }

        private void discard() {
            this.published = true;
            this.capabilityRegistry.rollback();
            ControllerLogger.MGMT_OP_LOGGER.tracef("discarded %s", (Object)this);
        }
    }

    private static class MutableRootResourceRegistrationProviderImpl
    implements MutableRootResourceRegistrationProvider {
        private static final MutableRootResourceRegistrationProvider INSTANCE = new MutableRootResourceRegistrationProviderImpl();

        private MutableRootResourceRegistrationProviderImpl() {
        }

        @Override
        public ManagementResourceRegistration getRootResourceRegistrationForUpdate(OperationContext context) {
            assert (context instanceof AbstractOperationContext);
            return ((AbstractOperationContext)context).getRootResourceRegistrationForUpdate();
        }
    }

    private final class ModelControllerResource
    extends PlaceholderResource.PlaceholderResourceEntry {
        private ModelControllerResource() {
            super("service", "management-operations");
        }

        @Override
        public boolean hasChild(PathElement element) {
            try {
                return "active-operation".equals(element.getKey()) && ModelControllerImpl.this.activeOperations.containsKey(Integer.valueOf(element.getValue()));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public Resource getChild(PathElement element) {
            Resource.ResourceEntry result = null;
            if ("active-operation".equals(element.getKey())) {
                try {
                    OperationContextImpl context = (OperationContextImpl)ModelControllerImpl.this.activeOperations.get(Integer.valueOf(element.getValue()));
                    if (context != null) {
                        result = context.getActiveOperationResource();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public Resource requireChild(PathElement element) {
            Resource resource = this.getChild(element);
            if (resource == null) {
                throw new Resource.NoSuchResourceException(element);
            }
            return resource;
        }

        @Override
        public boolean hasChildren(String childType) {
            return "active-operation".equals(childType) && ModelControllerImpl.this.activeOperations.size() > 0;
        }

        @Override
        public Set<String> getChildTypes() {
            return Collections.singleton("active-operation");
        }

        @Override
        public Set<String> getChildrenNames(String childType) {
            HashSet<String> result = new HashSet<String>(ModelControllerImpl.this.activeOperations.size());
            for (Integer id : ModelControllerImpl.this.activeOperations.keySet()) {
                result.add(id.toString());
            }
            return result;
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>(ModelControllerImpl.this.activeOperations.size());
            for (OperationContextImpl context : ModelControllerImpl.this.activeOperations.values()) {
                result.add(context.getActiveOperationResource());
            }
            return result;
        }
    }

    private static final class BootOperations {
        private final List<ParsedBootOp> initialOps;
        private final List<ParsedBootOp> postExtensionOps;
        private final boolean invalid;

        private BootOperations(List<ParsedBootOp> initialOps, List<ParsedBootOp> postExtensionOps, boolean invalid) {
            this.initialOps = initialOps;
            this.postExtensionOps = postExtensionOps;
            this.invalid = invalid;
        }
    }

    private class DefaultPrepareStepHandler
    implements OperationStepHandler {
        private DefaultPrepareStepHandler() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String operationName;
            PathAddress address;
            OperationStepHandler stepHandler;
            if (ControllerLogger.MGMT_OP_LOGGER.isTraceEnabled()) {
                ControllerLogger.MGMT_OP_LOGGER.tracef("Executing %s %s", (Object)operation.get("operation"), (Object)operation.get("address"));
            }
            if ((stepHandler = ModelControllerImpl.this.resolveOperationHandler(address = context.getCurrentAddress(), operationName = operation.require("operation").asString())) != null) {
                context.addStep(stepHandler, OperationContext.Stage.MODEL);
            } else {
                ManagementResourceRegistration child = ((ManagementModelImpl)ModelControllerImpl.this.managementModel.get()).getRootResourceRegistration().getSubModel(address);
                if (child == null) {
                    context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.noSuchResourceType(address));
                } else {
                    context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(operationName, address));
                }
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }
}

