/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller;

import java.util.ResourceBundle;
import org.shaded.jboss.as.controller.descriptions.DefaultNotificationDescriptionProvider;
import org.shaded.jboss.as.controller.descriptions.DescriptionProvider;
import org.shaded.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.shaded.jboss.dmr.ModelNode;

public class NotificationDefinition {
    private final String type;
    private final ResourceDescriptionResolver resolver;
    private final DataValueDescriptor dataValueDescriptor;

    private NotificationDefinition(String type, ResourceDescriptionResolver resolver, DataValueDescriptor dataValueDescriptor) {
        this.type = type;
        this.resolver = resolver;
        this.dataValueDescriptor = dataValueDescriptor;
    }

    public String getType() {
        return this.type;
    }

    public DescriptionProvider getDescriptionProvider() {
        return new DefaultNotificationDescriptionProvider(this.type, this.resolver, this.dataValueDescriptor);
    }

    public static interface DataValueDescriptor {
        public static final DataValueDescriptor NO_DATA = new DataValueDescriptor(){

            @Override
            public ModelNode describe(ResourceBundle bundle2) {
                return null;
            }
        };

        public ModelNode describe(ResourceBundle var1);
    }

    public static class Builder {
        private final String type;
        private final ResourceDescriptionResolver resolver;
        private DataValueDescriptor dataValueDescriptor = DataValueDescriptor.NO_DATA;

        private Builder(String type, ResourceDescriptionResolver resolver) {
            this.type = type;
            this.resolver = resolver;
        }

        public static Builder create(String type, ResourceDescriptionResolver resolver) {
            return new Builder(type, resolver);
        }

        public Builder setDataValueDescriptor(DataValueDescriptor dataValueDescriptor) {
            this.dataValueDescriptor = dataValueDescriptor;
            return this;
        }

        public NotificationDefinition build() {
            return new NotificationDefinition(this.type, this.resolver, this.dataValueDescriptor);
        }
    }
}

