/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.shaded.jboss.as.controller.AttributeDefinition;
import org.shaded.jboss.as.controller.DeprecationData;
import org.shaded.jboss.as.controller.OperationFailedException;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.shaded.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.shaded.jboss.as.controller.descriptions.DescriptionProvider;
import org.shaded.jboss.as.controller.logging.ControllerLogger;
import org.shaded.jboss.as.controller.registry.OperationEntry;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;

public abstract class OperationDefinition {
    protected final String name;
    protected final OperationEntry.EntryType entryType;
    protected final EnumSet<OperationEntry.Flag> flags;
    protected final AttributeDefinition[] parameters;
    protected final ModelType replyType;
    protected final ModelType replyValueType;
    protected final boolean replyAllowNull;
    protected final DeprecationData deprecationData;
    protected final AttributeDefinition[] replyParameters;
    protected final List<AccessConstraintDefinition> accessConstraints;
    protected final DescriptionProvider descriptionProvider;

    protected OperationDefinition(SimpleOperationDefinitionBuilder builder) {
        this.name = builder.name;
        this.entryType = builder.entryType;
        this.flags = builder.flags;
        this.parameters = builder.parameters;
        this.replyType = builder.replyType;
        this.replyValueType = builder.replyValueType;
        this.replyAllowNull = builder.replyAllowNull;
        this.deprecationData = builder.deprecationData;
        this.replyParameters = builder.replyParameters;
        this.accessConstraints = builder.accessConstraints == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(builder.accessConstraints));
        this.descriptionProvider = builder.descriptionProvider;
    }

    @Deprecated
    protected OperationDefinition(String name, OperationEntry.EntryType entryType, EnumSet<OperationEntry.Flag> flags, ModelType replyType, ModelType replyValueType, boolean replyAllowNull, DeprecationData deprecationData, AttributeDefinition[] replyParameters, AttributeDefinition[] parameters, AccessConstraintDefinition ... accessConstraints) {
        this.name = name;
        this.entryType = entryType;
        this.flags = flags;
        this.parameters = parameters;
        this.replyType = replyType;
        this.replyValueType = replyValueType;
        this.replyAllowNull = replyAllowNull;
        this.deprecationData = deprecationData;
        this.replyParameters = replyParameters;
        this.accessConstraints = accessConstraints == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(accessConstraints));
        this.descriptionProvider = null;
    }

    public String getName() {
        return this.name;
    }

    public OperationEntry.EntryType getEntryType() {
        return this.entryType;
    }

    public EnumSet<OperationEntry.Flag> getFlags() {
        return this.flags;
    }

    public AttributeDefinition[] getParameters() {
        return this.parameters;
    }

    public ModelType getReplyType() {
        return this.replyType;
    }

    public ModelType getReplyValueType() {
        return this.replyValueType;
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }

    public abstract DescriptionProvider getDescriptionProvider();

    public DeprecationData getDeprecationData() {
        return this.deprecationData;
    }

    public boolean isDeprecated() {
        return this.deprecationData != null;
    }

    public boolean isReplyAllowNull() {
        return this.replyAllowNull;
    }

    public AttributeDefinition[] getReplyParameters() {
        return this.replyParameters;
    }

    public void validateOperation(ModelNode operation) throws OperationFailedException {
        if (operation.hasDefined("operation-name") && this.deprecationData != null && this.deprecationData.isNotificationUseful()) {
            ControllerLogger.DEPRECATED_LOGGER.operationDeprecated(this.getName(), PathAddress.pathAddress(operation.get("address")).toCLIStyleString());
        }
        for (AttributeDefinition ad : this.parameters) {
            ad.validateOperation(operation);
        }
    }

    public final void validateAndSet(ModelNode operationObject, ModelNode model) throws OperationFailedException {
        this.validateOperation(operationObject);
        for (AttributeDefinition ad : this.parameters) {
            ad.validateAndSet(operationObject, model);
        }
    }
}

