/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.access.constraint;

import org.shaded.jboss.as.controller.access.Action;

public class AbstractSensitivity {
    private final boolean defaultRequiresAccessPermission;
    private final boolean defaultRequiresReadPermission;
    private final boolean defaultRequiresWritePermission;
    private volatile Boolean configuredRequiresAccessPermission;
    private volatile Boolean configuredRequiresReadPermission;
    private volatile Boolean configuredRequiresWritePermission;

    protected AbstractSensitivity(boolean defaultRequiresAccessPermission, boolean defaultRequiresReadPermission, boolean defaultRequiresWritePermission) {
        this.defaultRequiresAccessPermission = defaultRequiresAccessPermission;
        this.defaultRequiresReadPermission = defaultRequiresReadPermission;
        this.defaultRequiresWritePermission = defaultRequiresWritePermission;
    }

    public boolean isDefaultRequiresAccessPermission() {
        return this.defaultRequiresAccessPermission;
    }

    public boolean isDefaultRequiresReadPermission() {
        return this.defaultRequiresReadPermission;
    }

    public boolean isDefaultRequiresWritePermission() {
        return this.defaultRequiresWritePermission;
    }

    public boolean getRequiresAccessPermission() {
        Boolean requires = this.configuredRequiresAccessPermission;
        return requires == null ? this.defaultRequiresAccessPermission : requires;
    }

    public Boolean getConfiguredRequiresAccessPermission() {
        return this.configuredRequiresAccessPermission;
    }

    public void setConfiguredRequiresAccessPermission(Boolean requiresAccessPermission) {
        this.configuredRequiresAccessPermission = requiresAccessPermission;
    }

    public boolean getRequiresReadPermission() {
        Boolean requires = this.configuredRequiresReadPermission;
        return requires == null ? this.defaultRequiresReadPermission : requires;
    }

    public Boolean getConfiguredRequiresReadPermission() {
        return this.configuredRequiresReadPermission;
    }

    public void setConfiguredRequiresReadPermission(Boolean requiresReadPermission) {
        this.configuredRequiresReadPermission = requiresReadPermission;
    }

    public boolean getRequiresWritePermission() {
        Boolean requires = this.configuredRequiresWritePermission;
        return requires == null ? this.defaultRequiresWritePermission : requires;
    }

    public Boolean getConfiguredRequiresWritePermission() {
        return this.configuredRequiresWritePermission;
    }

    public boolean isSensitive(Action.ActionEffect actionEffect) {
        if (actionEffect == Action.ActionEffect.ADDRESS) {
            return this.getRequiresAccessPermission();
        }
        if (actionEffect == Action.ActionEffect.READ_CONFIG || actionEffect == Action.ActionEffect.READ_RUNTIME) {
            return this.getRequiresReadPermission();
        }
        return this.getRequiresWritePermission();
    }

    public void setConfiguredRequiresWritePermission(Boolean requiresWritePermission) {
        this.configuredRequiresWritePermission = requiresWritePermission;
    }

    protected boolean isCompatibleWith(AbstractSensitivity other) {
        return !this.equals(other) || this.defaultRequiresAccessPermission == other.defaultRequiresAccessPermission && this.defaultRequiresReadPermission == other.defaultRequiresReadPermission && this.defaultRequiresWritePermission == other.defaultRequiresWritePermission;
    }
}

