/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.access.constraint;

import org.shaded.jboss.as.controller.access.Action;
import org.shaded.jboss.as.controller.access.JmxAction;
import org.shaded.jboss.as.controller.access.JmxTarget;
import org.shaded.jboss.as.controller.access.TargetAttribute;
import org.shaded.jboss.as.controller.access.TargetResource;
import org.shaded.jboss.as.controller.access.constraint.AbstractConstraintFactory;
import org.shaded.jboss.as.controller.access.constraint.AllowAllowNotConstraint;
import org.shaded.jboss.as.controller.access.constraint.AuditLogAddressUtil;
import org.shaded.jboss.as.controller.access.constraint.Constraint;
import org.shaded.jboss.as.controller.access.constraint.ConstraintFactory;
import org.shaded.jboss.as.controller.access.constraint.ScopingConstraintFactory;
import org.shaded.jboss.as.controller.access.rbac.StandardRole;

public class AuditConstraint
extends AllowAllowNotConstraint {
    public static final ConstraintFactory FACTORY = new Factory();
    private static final AuditConstraint AUDIT = new AuditConstraint(true);
    private static final AuditConstraint NOT_AUDIT = new AuditConstraint(false);
    private static final AuditConstraint ALLOWS = new AuditConstraint(true, true);
    private static final AuditConstraint DISALLOWS = new AuditConstraint(false, true);

    private AuditConstraint(boolean isAudit) {
        super(isAudit);
    }

    private AuditConstraint(boolean allowsAudit, boolean allowsNonAudit) {
        super(allowsAudit, allowsNonAudit);
    }

    static class Factory
    extends AbstractConstraintFactory {
        Factory() {
        }

        @Override
        public Constraint getStandardUserConstraint(StandardRole role, Action.ActionEffect actionEffect) {
            if (actionEffect == Action.ActionEffect.ADDRESS) {
                return ALLOWS;
            }
            return role == StandardRole.AUDITOR || role == StandardRole.SUPERUSER ? ALLOWS : DISALLOWS;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetAttribute target) {
            return this.getRequiredConstraint(actionEffect, action, target.getTargetResource());
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, Action action, TargetResource target) {
            return this.isAuditResource(target) ? AUDIT : NOT_AUDIT;
        }

        private boolean isAuditResource(TargetResource target) {
            return AuditLogAddressUtil.isAuditLogAddress(target.getResourceAddress());
        }

        @Override
        protected int internalCompare(AbstractConstraintFactory other) {
            return other instanceof ScopingConstraintFactory ? 1 : -1;
        }

        @Override
        public Constraint getRequiredConstraint(Action.ActionEffect actionEffect, JmxAction action, JmxTarget target) {
            return NOT_AUDIT;
        }
    }
}

