/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.access.constraint;

import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.PathElement;

public class AuditLogAddressUtil {
    private static final PathAddress STANDALONE_CORE_AUDIT_LOG = PathAddress.pathAddress(PathElement.pathElement("core-service", "management"), PathElement.pathElement("access", "audit"));
    private static final PathAddress HOST_AUDIT_LOG = PathAddress.pathAddress(PathElement.pathElement("host")).append(STANDALONE_CORE_AUDIT_LOG);
    private static final PathAddress STANDALONE_JMX_AUDIT_LOG = PathAddress.pathAddress(PathElement.pathElement("subsystem", "jmx"), PathElement.pathElement("configuration", "audit-log"));
    private static final PathAddress DOMAIN_AUDIT_LOG = PathAddress.pathAddress(PathElement.pathElement("profile")).append(STANDALONE_JMX_AUDIT_LOG);
    private static final PathAddress[] AUDIT_LOG_ADDRESSES = new PathAddress[]{STANDALONE_CORE_AUDIT_LOG, HOST_AUDIT_LOG, STANDALONE_JMX_AUDIT_LOG, DOMAIN_AUDIT_LOG};

    static boolean isAuditLogAddress(PathAddress address) {
        for (PathAddress pattern : AUDIT_LOG_ADDRESSES) {
            if (!AuditLogAddressUtil.matches(pattern, address)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(PathAddress pattern, PathAddress address) {
        if (address.size() >= pattern.size()) {
            for (int i = 0; i < pattern.size(); ++i) {
                if (AuditLogAddressUtil.matches(pattern.getElement(i), address.getElement(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean matches(PathElement pattern, PathElement element) {
        if (!pattern.getKey().equals(element.getKey())) {
            return false;
        }
        if (pattern.isWildcard()) {
            return true;
        }
        return pattern.getValue().equals(element.getValue());
    }
}

