/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.access.rbac;

import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import org.shaded.jboss.as.controller.access.Action;

public enum StandardRole {
    MONITOR("Monitor", Action.ActionEffect.READ_CONFIG, Action.ActionEffect.READ_RUNTIME),
    OPERATOR("Operator", Action.ActionEffect.READ_CONFIG, Action.ActionEffect.READ_RUNTIME, Action.ActionEffect.WRITE_RUNTIME),
    MAINTAINER("Maintainer"),
    DEPLOYER("Deployer"),
    ADMINISTRATOR("Administrator"),
    AUDITOR("Auditor"),
    SUPERUSER("SuperUser");

    private final String name;
    private final Set<Action.ActionEffect> allowedActions;

    private StandardRole(String name) {
        this(name, Action.ActionEffect.values());
    }

    private StandardRole(String name, Action.ActionEffect ... allowedExcludingAccess) {
        this(name, EnumSet.of(Action.ActionEffect.ADDRESS, allowedExcludingAccess));
    }

    private StandardRole(String name, Set<Action.ActionEffect> allowedActions) {
        this.name = name;
        this.allowedActions = allowedActions;
    }

    public boolean isActionEffectAllowed(Action.ActionEffect actionEffect) {
        return this.allowedActions.contains((Object)actionEffect);
    }

    public String getFormalName() {
        return this.name;
    }

    public String getOfficialForm() {
        return this.toString().toUpperCase(Locale.ENGLISH);
    }
}

