/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.capability.registry;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.capability.Capability;
import org.shaded.jboss.as.controller.capability.registry.CapabilityId;
import org.shaded.jboss.as.controller.capability.registry.CapabilityScope;
import org.shaded.jboss.as.controller.capability.registry.RegistrationPoint;

public class CapabilityRegistration<C extends Capability>
implements Comparable<CapabilityRegistration> {
    private final Map<PathAddress, RegistrationPoint> registrationPoints = new LinkedHashMap<PathAddress, RegistrationPoint>();
    private final C capability;
    private final CapabilityId id;

    public CapabilityRegistration(C capability, CapabilityScope scope) {
        this.capability = capability;
        this.id = new CapabilityId(capability.getName(), scope);
    }

    public CapabilityRegistration(C capability, CapabilityScope scope, RegistrationPoint registrationPoint) {
        this(capability, scope);
        this.registrationPoints.put(registrationPoint.getAddress(), registrationPoint);
    }

    public CapabilityRegistration(CapabilityRegistration<C> toCopy) {
        this(toCopy.getCapability(), toCopy.getCapabilityScope());
        this.registrationPoints.putAll(toCopy.registrationPoints);
    }

    public C getCapability() {
        return this.capability;
    }

    public CapabilityScope getCapabilityScope() {
        return this.id.getScope();
    }

    public String getCapabilityName() {
        return this.id.getName();
    }

    public CapabilityId getCapabilityId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapabilityRegistration that = (CapabilityRegistration)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public synchronized RegistrationPoint getOldestRegistrationPoint() {
        return this.registrationPoints.size() == 0 ? null : this.registrationPoints.values().iterator().next();
    }

    public synchronized Set<RegistrationPoint> getRegistrationPoints() {
        return Collections.unmodifiableSet(new LinkedHashSet<RegistrationPoint>(this.registrationPoints.values()));
    }

    public synchronized boolean addRegistrationPoint(RegistrationPoint toAdd) {
        PathAddress addedAddress = toAdd.getAddress();
        if (this.registrationPoints.containsKey(addedAddress)) {
            return false;
        }
        this.registrationPoints.put(addedAddress, toAdd);
        return true;
    }

    public synchronized boolean removeRegistrationPoint(RegistrationPoint toAdd) {
        PathAddress addedAddress = toAdd.getAddress();
        if (!this.registrationPoints.containsKey(addedAddress)) {
            return false;
        }
        this.registrationPoints.remove(addedAddress);
        return true;
    }

    public synchronized int getRegistrationPointCount() {
        return this.registrationPoints.size();
    }

    @Override
    public int compareTo(CapabilityRegistration o) {
        return this.id.compareTo(o.id);
    }
}

