/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.client.helpers.domain.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import org.shaded.jboss.as.controller.client.Operation;
import org.shaded.jboss.as.controller.client.OperationBuilder;
import org.shaded.jboss.as.controller.client.helpers.domain.DeploymentPlan;
import org.shaded.jboss.as.controller.client.helpers.domain.DeploymentPlanResult;
import org.shaded.jboss.as.controller.client.helpers.domain.DomainDeploymentManager;
import org.shaded.jboss.as.controller.client.helpers.domain.DuplicateDeploymentNameException;
import org.shaded.jboss.as.controller.client.helpers.domain.InitialDeploymentPlanBuilder;
import org.shaded.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlan;
import org.shaded.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.shaded.jboss.as.controller.client.helpers.domain.impl.DeploymentActionImpl;
import org.shaded.jboss.as.controller.client.helpers.domain.impl.DeploymentContentDistributor;
import org.shaded.jboss.as.controller.client.helpers.domain.impl.DeploymentPlanImpl;
import org.shaded.jboss.as.controller.client.helpers.domain.impl.DomainClientImpl;
import org.shaded.jboss.as.controller.client.helpers.domain.impl.DomainDeploymentPlanResultFuture;
import org.shaded.jboss.as.controller.client.helpers.domain.impl.InitialDeploymentPlanBuilderFactory;
import org.shaded.jboss.as.controller.client.logging.ControllerClientLogger;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.threads.AsyncFuture;

class DomainDeploymentManagerImpl
implements DomainDeploymentManager {
    private final DomainClientImpl client;
    private final DeploymentContentDistributor contentDistributor;

    DomainDeploymentManagerImpl(DomainClientImpl client) {
        assert (client != null) : "client is null";
        this.client = client;
        this.contentDistributor = new DeploymentContentDistributor(){

            @Override
            public byte[] distributeDeploymentContent(String name, String runtimeName, InputStream stream) throws IOException, DuplicateDeploymentNameException {
                boolean unique = DomainDeploymentManagerImpl.this.client.isDeploymentNameUnique(name);
                if (!unique) {
                    throw new DuplicateDeploymentNameException(name, false);
                }
                return DomainDeploymentManagerImpl.this.client.addDeploymentContent(stream);
            }

            @Override
            public byte[] distributeReplacementDeploymentContent(String name, String runtimeName, InputStream stream) throws IOException {
                return DomainDeploymentManagerImpl.this.client.addDeploymentContent(stream);
            }
        };
    }

    @Override
    public Future<DeploymentPlanResult> execute(DeploymentPlan plan) {
        if (!(plan instanceof DeploymentPlanImpl)) {
            throw ControllerClientLogger.ROOT_LOGGER.cannotUseDeploymentPlan();
        }
        DeploymentPlanImpl planImpl = (DeploymentPlanImpl)DeploymentPlanImpl.class.cast(plan);
        HashMap<UUID, List<String>> actionsById = new HashMap<UUID, List<String>>();
        Operation operation = this.getDeploymentPlanOperation(planImpl, actionsById);
        AsyncFuture<ModelNode> future = this.client.executeAsync(operation, null);
        return new DomainDeploymentPlanResultFuture(planImpl, future, new LinkedHashSet<ServerIdentity>(this.client.getServerStatuses().keySet()), actionsById);
    }

    @Override
    public InitialDeploymentPlanBuilder newDeploymentPlan() {
        return InitialDeploymentPlanBuilderFactory.newInitialDeploymentPlanBuilder(this.contentDistributor);
    }

    private Operation getDeploymentPlanOperation(DeploymentPlanImpl plan, Map<UUID, List<String>> actionsById) {
        Operation op = this.getCompositeOperation(plan, actionsById);
        this.addRollbackPlan(plan, op);
        return op;
    }

    private Operation getCompositeOperation(DeploymentPlanImpl plan, Map<UUID, List<String>> actionsById) {
        Set<String> deployments = this.getCurrentDomainDeployments();
        Set<String> serverGroups = this.getServerGroupNames(plan);
        ModelNode op = new ModelNode();
        op.get("operation").set("composite");
        op.get("address").setEmptyList();
        ModelNode steps = op.get("steps");
        steps.setEmptyList();
        op.get("operation-headers", "rollback-on-runtime-failure").set(plan.isSingleServerRollback());
        OperationBuilder builder = new OperationBuilder(op);
        int stepNum = 1;
        for (DeploymentActionImpl action : plan.getDeploymentActionImpls()) {
            ArrayList<String> actionStepIds = new ArrayList<String>();
            actionsById.put(action.getId(), actionStepIds);
            ArrayList<Object> actionSteps = new ArrayList<Object>();
            String uniqueName = action.getDeploymentUnitUniqueName();
            switch (action.getType()) {
                case ADD: {
                    ModelNode groupStep;
                    Object step;
                    if (!deployments.contains(uniqueName)) {
                        step = this.configureDeploymentOperation("add", uniqueName, null);
                        ((ModelNode)step).get("runtime-name").set(action.getNewContentFileName());
                        ((ModelNode)step).get("content").get(0).get("hash").set(action.getNewContentHash());
                        actionSteps.add(step);
                    }
                    for (String string : serverGroups) {
                        groupStep = this.configureDeploymentOperation("add", uniqueName, string);
                        actionSteps.add(groupStep);
                    }
                    break;
                }
                case DEPLOY: {
                    ModelNode groupStep;
                    for (String string : serverGroups) {
                        groupStep = this.configureDeploymentOperation("deploy", uniqueName, string);
                        actionSteps.add(groupStep);
                    }
                    break;
                }
                case FULL_REPLACE: {
                    Object step = new ModelNode();
                    ((ModelNode)step).get("operation").set("full-replace-deployment");
                    ((ModelNode)step).get("address").setEmptyList();
                    ((ModelNode)step).get("name").set(uniqueName);
                    ((ModelNode)step).get("runtime-name").set(action.getNewContentFileName());
                    ((ModelNode)step).get("content").get(0).get("hash").set(action.getNewContentHash());
                    actionSteps.add(step);
                    break;
                }
                case REDEPLOY: {
                    ModelNode groupStep;
                    for (String string : serverGroups) {
                        groupStep = this.configureDeploymentOperation("redeploy", uniqueName, string);
                        actionSteps.add(groupStep);
                    }
                    break;
                }
                case REMOVE: {
                    ModelNode groupStep;
                    for (String string : serverGroups) {
                        groupStep = this.configureDeploymentOperation("remove", uniqueName, string);
                        actionSteps.add(groupStep);
                    }
                    Object step = this.configureDeploymentOperation("remove", uniqueName, null);
                    actionSteps.add(step);
                    break;
                }
                case REPLACE: {
                    ModelNode groupStep;
                    for (String string : serverGroups) {
                        groupStep = new ModelNode();
                        groupStep.get("operation").set("replace-deployment");
                        groupStep.get("address").add("server-group", string);
                        groupStep.get("name").set(uniqueName);
                        groupStep.get("to-replace").set(action.getReplacedDeploymentUnitUniqueName());
                        actionSteps.add(groupStep);
                    }
                    break;
                }
                case UNDEPLOY: {
                    ModelNode groupStep;
                    for (String string : serverGroups) {
                        groupStep = this.configureDeploymentOperation("undeploy", uniqueName, string);
                        actionSteps.add(groupStep);
                    }
                    break;
                }
                default: {
                    throw ControllerClientLogger.ROOT_LOGGER.unknownActionType((Object)action.getType());
                }
            }
            for (ModelNode modelNode : actionSteps) {
                actionStepIds.add(String.format("step-%d", stepNum++));
                steps.add(modelNode);
            }
        }
        return builder.build();
    }

    private Set<String> getCurrentDomainDeployments() {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-children-names");
        op.get("child-type").set("deployment");
        ModelNode rsp = this.client.executeForResult(new OperationBuilder(op).build());
        HashSet<String> deployments = new HashSet<String>();
        if (rsp.isDefined()) {
            for (ModelNode node : rsp.asList()) {
                deployments.add(node.asString());
            }
        }
        return deployments;
    }

    private void addRollbackPlan(DeploymentPlanImpl plan, Operation op) {
        ModelNode opNode = op.getOperation();
        ModelNode rolloutPlan = opNode.get("operation-headers", "rollout-plan");
        rolloutPlan.get("rollback-across-groups").set(plan.isRollbackAcrossGroups());
        ModelNode series = rolloutPlan.get("in-series");
        for (Set<ServerGroupDeploymentPlan> concurrent : plan.getServerGroupDeploymentPlans()) {
            if (concurrent.size() == 1) {
                ModelNode single = new ModelNode();
                ServerGroupDeploymentPlan sgdp = concurrent.iterator().next();
                single.get("server-group", sgdp.getServerGroupName()).set(this.createServerGroupPlan(sgdp));
                series.add(single);
                continue;
            }
            ModelNode multiple = new ModelNode();
            for (ServerGroupDeploymentPlan sgdp : concurrent) {
                multiple.get("concurrent-groups", sgdp.getServerGroupName()).set(this.createServerGroupPlan(sgdp));
            }
            series.add(multiple);
        }
    }

    private ModelNode createServerGroupPlan(ServerGroupDeploymentPlan sgdp) {
        ModelNode result = new ModelNode();
        result.get("rolling-to-servers").set(sgdp.isRollingToServers());
        if (sgdp.isRollback()) {
            if (sgdp.getMaxServerFailurePercentage() > 0) {
                result.get("max-failure-percentage").set(sgdp.getMaxServerFailurePercentage());
            } else {
                result.get("max-failed-servers").set(sgdp.getMaxServerFailures());
            }
        } else {
            result.get("max-failure-percentage").set(100);
        }
        return result;
    }

    private Set<String> getServerGroupNames(DeploymentPlan plan) {
        HashSet<String> names = new HashSet<String>();
        for (Set<ServerGroupDeploymentPlan> sgdps : plan.getServerGroupDeploymentPlans()) {
            for (ServerGroupDeploymentPlan sgdp : sgdps) {
                names.add(sgdp.getServerGroupName());
            }
        }
        return names;
    }

    private ModelNode configureDeploymentOperation(String operationName, String uniqueName, String serverGroup) {
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        if (serverGroup != null) {
            op.get("address").add("server-group", serverGroup);
        }
        op.get("address").add("deployment", uniqueName);
        return op;
    }
}

