/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.client.helpers.domain.impl;

import org.shaded.jboss.as.controller.client.helpers.domain.DeploymentAction;
import org.shaded.jboss.as.controller.client.helpers.domain.RemoveDeploymentPlanBuilder;
import org.shaded.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlanBuilder;
import org.shaded.jboss.as.controller.client.helpers.domain.UndeployDeploymentPlanBuilder;
import org.shaded.jboss.as.controller.client.helpers.domain.impl.DeploymentActionImpl;
import org.shaded.jboss.as.controller.client.helpers.domain.impl.DeploymentPlanBuilderImpl;
import org.shaded.jboss.as.controller.client.helpers.domain.impl.DeploymentSetPlanImpl;
import org.shaded.jboss.as.controller.client.helpers.domain.impl.RemoveDeploymentPlanBuilderImpl;
import org.shaded.jboss.as.controller.client.logging.ControllerClientLogger;

class UndeployDeploymentPlanBuilderImpl
extends DeploymentPlanBuilderImpl
implements UndeployDeploymentPlanBuilder {
    private final DeploymentAction undeployModification;

    UndeployDeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, DeploymentSetPlanImpl setPlan) {
        super(existing, setPlan);
        DeploymentAction modification = setPlan.getLastAction();
        if (modification.getType() != DeploymentAction.Type.UNDEPLOY) {
            throw ControllerClientLogger.ROOT_LOGGER.invalidActionType(modification.getType());
        }
        this.undeployModification = modification;
    }

    @Override
    public ServerGroupDeploymentPlanBuilder toServerGroup(String serverGroupName) {
        return super.toServerGroup(serverGroupName);
    }

    @Override
    public RemoveDeploymentPlanBuilder andRemoveUndeployed() {
        DeploymentSetPlanImpl currentSet = this.getCurrentDeploymentSetPlan();
        if (currentSet.hasServerGroupPlans()) {
            throw ControllerClientLogger.ROOT_LOGGER.cannotAddDeploymentActionsAfterStart();
        }
        DeploymentActionImpl mod = DeploymentActionImpl.getRemoveAction(this.undeployModification.getDeploymentUnitUniqueName());
        DeploymentSetPlanImpl newSet = currentSet.addAction(mod);
        return new RemoveDeploymentPlanBuilderImpl((DeploymentPlanBuilderImpl)this, newSet);
    }
}

