/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.client.impl;

import java.net.URI;
import java.net.URISyntaxException;
import org.shaded.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.shaded.jboss.as.protocol.ProtocolChannelClient;
import org.xnio.OptionMap;

class ProtocolConfigurationFactory {
    private static final OptionMap DEFAULT_OPTIONS = OptionMap.EMPTY;

    ProtocolConfigurationFactory() {
    }

    static ProtocolChannelClient.Configuration create(ModelControllerClientConfiguration client) throws URISyntaxException {
        ProtocolChannelClient.Configuration configuration = new ProtocolChannelClient.Configuration();
        if (client.getProtocol() == null) {
            String protocol = client.getPort() == 9999 ? "remote://" : "http-remoting://";
            configuration.setUri(new URI(protocol + ProtocolConfigurationFactory.formatPossibleIpv6Address(client.getHost()) + ":" + client.getPort()));
        } else {
            configuration.setUri(new URI(client.getProtocol() + "://" + ProtocolConfigurationFactory.formatPossibleIpv6Address(client.getHost()) + ":" + client.getPort()));
        }
        configuration.setClientBindAddress(client.getClientBindAddress());
        configuration.setOptionMap(DEFAULT_OPTIONS);
        long timeout = client.getConnectionTimeout();
        if (timeout > 0L) {
            configuration.setConnectionTimeout(timeout);
        }
        return configuration;
    }

    private static String formatPossibleIpv6Address(String address) {
        if (address == null) {
            return address;
        }
        if (!address.contains(":")) {
            return address;
        }
        if (address.startsWith("[") && address.endsWith("]")) {
            return address;
        }
        return "[" + address + "]";
    }
}

