/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.descriptions;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.shaded.jboss.as.controller.AttributeDefinition;
import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.shaded.jboss.as.controller.descriptions.DescriptionProvider;
import org.shaded.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.shaded.jboss.as.controller.registry.AttributeAccess;
import org.shaded.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.shaded.jboss.dmr.ModelNode;
import org.shaded.jboss.dmr.ModelType;

public class DefaultResourceAddDescriptionProvider
implements DescriptionProvider {
    private static AttributeDefinition INDEX = SimpleAttributeDefinitionBuilder.create("add-index", ModelType.INT, true).build();
    private final ImmutableManagementResourceRegistration registration;
    final ResourceDescriptionResolver descriptionResolver;
    final boolean orderedChildResource;

    public DefaultResourceAddDescriptionProvider(ImmutableManagementResourceRegistration registration, ResourceDescriptionResolver descriptionResolver) {
        this(registration, descriptionResolver, false);
    }

    public DefaultResourceAddDescriptionProvider(ImmutableManagementResourceRegistration registration, ResourceDescriptionResolver descriptionResolver, boolean orderedChildResource) {
        this.registration = registration;
        this.descriptionResolver = descriptionResolver;
        this.orderedChildResource = orderedChildResource;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        ModelNode result = new ModelNode();
        ResourceBundle bundle2 = this.descriptionResolver.getResourceBundle(locale);
        result.get("operation-name").set("add");
        result.get("description").set(this.descriptionResolver.getOperationDescription("add", locale, bundle2));
        Set<String> attributeNames = this.registration.getAttributeNames(PathAddress.EMPTY_ADDRESS);
        TreeMap<AttributeDefinition.NameAndGroup, ModelNode> sortedDescriptions = new TreeMap<AttributeDefinition.NameAndGroup, ModelNode>();
        for (String attr : attributeNames) {
            AttributeAccess attributeAccess = this.registration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, attr);
            if (attributeAccess.getStorageType() != AttributeAccess.Storage.CONFIGURATION) continue;
            AttributeDefinition def = attributeAccess.getAttributeDefinition();
            if (def != null) {
                if (def.isResourceOnly()) continue;
                this.addAttributeDescriptionToMap(sortedDescriptions, def, locale, bundle2);
                continue;
            }
            sortedDescriptions.put(new AttributeDefinition.NameAndGroup(attr), new ModelNode());
        }
        if (this.orderedChildResource) {
            this.addAttributeDescriptionToMap(sortedDescriptions, INDEX, locale, bundle2);
        }
        ModelNode params = result.get("request-properties").setEmptyObject();
        for (Map.Entry entry : sortedDescriptions.entrySet()) {
            params.get(((AttributeDefinition.NameAndGroup)entry.getKey()).getName()).set((ModelNode)entry.getValue());
        }
        result.get("reply-properties").setEmptyObject();
        return result;
    }

    private void addAttributeDescriptionToMap(Map<AttributeDefinition.NameAndGroup, ModelNode> sortedDescriptions, AttributeDefinition def, Locale locale, ResourceBundle bundle2) {
        ModelNode attrDesc = new ModelNode();
        def.addOperationParameterDescription(attrDesc, "add", this.descriptionResolver, locale, bundle2);
        sortedDescriptions.put(new AttributeDefinition.NameAndGroup(def), attrDesc.get("request-properties", def.getName()));
    }
}

