/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.interfaces;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.shaded.jboss.as.controller.interfaces.AbstractInterfaceCriteria;
import org.shaded.jboss.as.controller.logging.ControllerLogger;

public class LoopbackAddressInterfaceCriteria
extends AbstractInterfaceCriteria {
    private static final long serialVersionUID = 1L;
    private String address;
    private InetAddress resolved;
    private boolean unknownHostLogged;

    public LoopbackAddressInterfaceCriteria(InetAddress address) {
        if (address == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("address");
        }
        this.resolved = address;
        this.address = this.resolved.getHostAddress();
    }

    public LoopbackAddressInterfaceCriteria(String address) {
        if (address == null) {
            throw ControllerLogger.ROOT_LOGGER.nullVar("address");
        }
        this.address = address;
    }

    public synchronized InetAddress getAddress() throws UnknownHostException {
        if (this.resolved == null) {
            this.resolved = InetAddress.getByName(this.address);
        }
        return this.resolved;
    }

    @Override
    protected InetAddress isAcceptable(NetworkInterface networkInterface, InetAddress address) throws SocketException {
        block3: {
            try {
                if (networkInterface.isLoopback()) {
                    return this.getAddress();
                }
            }
            catch (UnknownHostException e) {
                if (this.unknownHostLogged) break block3;
                ControllerLogger.MGMT_OP_LOGGER.cannotResolveAddress(this.address);
                this.unknownHostLogged = true;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LoopbackAddressInterfaceCriteria(");
        sb.append("address=");
        sb.append(this.address);
        sb.append(",resolved=");
        sb.append(this.resolved);
        sb.append(')');
        return sb.toString();
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof LoopbackAddressInterfaceCriteria && this.address.equals(((LoopbackAddressInterfaceCriteria)o).address);
    }
}

