/*
 * Decompiled with CFR 0.152.
 */
package org.shaded.jboss.as.controller.notification;

import org.shaded.jboss.as.controller.PathAddress;
import org.shaded.jboss.dmr.ModelNode;

public class Notification {
    public static final String SOURCE = "source";
    public static final String TYPE = "type";
    public static final String MESSAGE = "message";
    public static final String TIMESTAMP = "timestamp";
    public static final String DATA = "data";
    private final String type;
    private final PathAddress source;
    private final String message;
    private final long timestamp;
    private final ModelNode data;

    public Notification(String type, PathAddress source, String message) {
        this(type, source, message, null);
    }

    public Notification(String type, PathAddress source, String message, ModelNode data) {
        this(type, source, message, System.currentTimeMillis(), data);
    }

    private Notification(String type, PathAddress source, String message, long timestamp, ModelNode data) {
        this.type = type;
        this.source = source;
        this.message = message;
        this.timestamp = timestamp;
        this.data = data;
    }

    public String getType() {
        return this.type;
    }

    public PathAddress getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ModelNode getData() {
        return this.data;
    }

    public ModelNode toModelNode() {
        ModelNode node = new ModelNode();
        node.get(TYPE).set(this.type);
        node.get(SOURCE).set(this.source.toModelNode());
        node.get(TIMESTAMP).set(this.timestamp);
        node.get(MESSAGE).set(this.message);
        if (this.data != null) {
            node.get(DATA).set(this.data);
        }
        node.protect();
        return node;
    }

    public static Notification fromModelNode(ModelNode node) {
        String type = node.require(TYPE).asString();
        PathAddress source = PathAddress.pathAddress(node.require(SOURCE));
        long timestamp = node.require(TIMESTAMP).asLong();
        String message = node.require(MESSAGE).asString();
        ModelNode data = node.hasDefined(DATA) ? node.get(DATA) : null;
        return new Notification(type, source, message, timestamp, data);
    }

    public String toString() {
        return "Notification{type='" + this.type + '\'' + ", source=" + this.source + ", message='" + this.message + '\'' + ", timestamp=" + this.timestamp + ", data=" + this.data + '}';
    }
}

